 -- Technologie
 -- Kostenstellenverzeichnis
 CREATE TABLE ksv
  (
   ks_id                serial       UNIQUE NOT NULL,
   ks_abt               varchar(9)   NOT NULL CONSTRAINT xtt5007 PRIMARY KEY, --Kostenstelle
   ks_top_ksabt         varchar(9),  -- Kopfkostenstelle
   ks_bz                varchar(50), -- Abteilung
   ks_bks               varchar(50), -- Bezeichnung
   ks_sort              varchar(50), -- Infos zum Standort der KS
   ks_allg1             varchar(50), -- Frei belegbar; veraltet: bei einigen Kunden für Umschlüsselung der KS für Buchhaltung benutzt
   ks_buchcode          varchar(20), -- (11/2015, Neu) Umcodierung für Buchhaltungssoftware. Zukünftig statt ks_allg1 nutzen.
   ks_ausw              boolean      DEFAULT FALSE, --Auswärtsbearbeitung
   ks_krzl              varchar(30)  NOT NULL DEFAULT '#' REFERENCES adressen_keys ON UPDATE CASCADE, -- Kurzname Auswärtsbearbeiiter
   ks_nap               numeric(2)   NOT NULL DEFAULT 1 CHECK (ks_nap >= 0),  -- Anzahl Arbeitsplätze
   ks_ba                numeric(4,2) NOT NULL DEFAULT 1 CHECK (ks_ba  >= 0), -- Anzahl Maschinen
   ks_babz              varchar(25), -- Arbeitsplatz
   ks_ba1               numeric(4,2) NOT NULL DEFAULT 0,
   ks_babz1             varchar(25),
   ks_ba2               numeric(4,2) NOT NULL DEFAULT 0,
   ks_babz2             varchar(25),
   ks_ba3               numeric(4,2) NOT NULL DEFAULT 0,
   ks_babz3             varchar(25),
   ks_ba4               numeric(4,2) NOT NULL DEFAULT 0,
   ks_babz4             varchar(25),
   ks_ba5               numeric(4,2) NOT NULL DEFAULT 0,
   ks_babz5             varchar(25),
   ks_ba6               numeric(4,2) NOT NULL DEFAULT 0,
   ks_babz6             varchar(25),
   ks_ba7               numeric(4,2) NOT NULL DEFAULT 0,
   ks_babz7             varchar(25),
   ks_ba8               numeric(4,2) NOT NULL DEFAULT 0,
   ks_babz8             varchar(25),
   ks_ba9               numeric(4,2) NOT NULL DEFAULT 0,
   ks_babz9             varchar(25),
   ks_ba10              numeric(4,2) NOT NULL DEFAULT 0,
   ks_babz10            varchar(25),
   ks_ba11              numeric(4,2) NOT NULL DEFAULT 0,
   ks_babz11            varchar(25),
   ks_ba12              numeric(4,2) NOT NULL DEFAULT 0,
   ks_babz12            varchar(25),
   ks_ba13              numeric(4,2) NOT NULL DEFAULT 0,
   ks_babz13            varchar(25),
   ks_ba14              numeric(4,2) NOT NULL DEFAULT 0,
   ks_babz14            varchar(25),
   ks_ba15              numeric(4,2) NOT NULL DEFAULT 0,
   ks_babz15            varchar(25),
   ks_ba16              numeric(4,2) NOT NULL DEFAULT 0,
   ks_babz16            varchar(25),
   ks_ba17              numeric(4,2) NOT NULL DEFAULT 0,
   ks_babz17            varchar(25),
   ks_ba18              numeric(4,2) NOT NULL DEFAULT 0,
   ks_babz18            varchar(25),
   ks_ba19              numeric(4,2) NOT NULL DEFAULT 0,
   ks_babz19            varchar(25),
   --Kapazität des Arbeitsplatz (Maschinenkapazität)
   ks_ka1               numeric      NOT NULL DEFAULT 0,--Sonntag
   ks_ka2               numeric      NOT NULL DEFAULT 8,
   ks_ka3               numeric      NOT NULL DEFAULT 8,
   ks_ka4               numeric      NOT NULL DEFAULT 8,
   ks_ka5               numeric      NOT NULL DEFAULT 8,
   ks_ka6               numeric      NOT NULL DEFAULT 8,--Freitag
   ks_ka7               numeric      NOT NULL DEFAULT 0,
   --
   ks_kf                numeric      NOT NULL DEFAULT 100, --Korrekturfaktor
   ks_nk                numeric(10,2), -- Normkapazität
   ks_kap               numeric(10,2), -- Kapazität
   -- Stundensätze
     -- Hinweis: unterhalb der Grenzstundensätze entstehen Verluste
   ks_sts               numeric(10,2),  -- Normstundensatz  Fertigung (Ausführung)
   ks_gss               numeric(10,2),  -- Grenzstundensatz Fertigung (Ausführung)
   ks_stsr              numeric(10,2),  -- Normstundensatz  Rüsten
   ks_gssr              numeric(10,2),  -- Grenzstundensatz Rüsten
   ks_stsm              numeric(10,2),  -- Normstundensatz  Bedienung (Personalzeit)
   ks_gssm              numeric(10,2),  -- Grenzstundensatz Bedienung (Personalzeit)
   -- Prüfen ob Verwendung in Fertigungszeitberechnung, wenn nicht dann entfernen.
   ks_mxd               integer, -- maximale Drehzahl der Maschine
   ks_vrs               integer, -- maximaler Vorschub der Maschine
   ks_eil               integer, -- Eilgang
   ks_wwz               integer, -- Zeit für Werkzeugwechsel  (Sekunden)
   ks_pwz               numeric, -- Zeit für Palettenwechsel  (Sekunden)
   ks_lez               numeric, -- Zeit für Werkstückwechsel (Sekunden)
   --Ende Maschinenparameter
   ks_dlz               numeric(10,2),       -- Durchlaufzeit in Tagen. Für Auswärtsbearbeiter sowie Sammelkostenstellen (Arbeitstage, ohne Wochenenden)
   ks_rsz               numeric,             -- Rüstzeit Vorschlag ASK
   ks_lgz               integer,             -- Liegezeit Vorschlag ASK
   ks_vtz               numeric DEFAULT 10,  -- Verteilzeit für ASK ks_nk->100% NK, ks_kap -> mit Korrekturfaktor
   ks_bc_id             varchar(20),         -- Barcode-Aktion für BDE-Stemp (z.B. NULL oder 'efftime' > siehe TFormKostenstellen.ks_bc_id_lookup und TFormBDEGetTime.ComPort1Data)
   --Plantafel-Einstellungen
   ks_notstemp          boolean NOT NULL DEFAULT false, -- in BDE ungültig
   ks_mitnc             boolean NOT NULL DEFAULT true,
   ks_sondkost          boolean NOT NULL DEFAULT false,
   ks_notInCalc         boolean NOT NULL DEFAULT false, -- Wenn true werden Kosten nicht in Einzelkosten der Nachkalkulation eingerechnet.
   ks_plan              boolean NOT NULL DEFAULT true,
   ks_weekfixauto       boolean NOT NULL DEFAULT false,
   ks_planinfo          boolean NOT NULL DEFAULT false,
   -- used for termination; all ab2 on this ksv must be terminated without regards to current capacity
   ks_force_dlz         boolean NOT NULL DEFAULT false,
   ks_sperr             boolean NOT NULL DEFAULT false, -- Kostenstelle ist gesperrt (Bspw. nicht mehr vorhandene)
   ks_sperr_datum       date,
   ks_forceruest        boolean NOT NULL DEFAULT false,
   ks_planpool          boolean DEFAULT false,
   ks_planpool_bdea_ap  boolean DEFAULT false,          -- Beim Stempeln auf Pool muß realer Arbeitsplatz eingegeben werden
   ks_timestart         time    DEFAULT '08:00',
   ks_timeend           time    DEFAULT '18:00',
   --
   ks_notin_prozfunc               boolean DEFAULT false,
   ks_bdea_pause_interrupts        boolean NOT NULL DEFAULT false,       -- Pausenstempelung unterbricht Auftragszeit
   ks_bdea_a2_ta_vorgabe           boolean NOT NULL DEFAULT false,       -- Vorgabezeiten von ab2 in Auftragszeitstempel vorschlagen
   ks_bdea_efftime_calc_by_stk     boolean NOT NULL DEFAULT false,        -- Vorgabe für Kostenstelle ist "Mehrmaschinenbedienung" : Zeit = Stückzahl * Stückzeit
   --
   ks_kinematic_group   varchar(2),                   -- Gruppierungskennzeichen für kinematisch baugleiche Maschinen
   ks_vf_group          varchar(2),                    -- veraltet! clont per ksv__obsolet_column__ks_vf_group auf         ks_kinematic_group; wird in 21.11 entfernt
   --
   ks_pz_para_proz      numeric    -- prozentualer Anteil der Hauptzeit, welche als parallele Personalzeit zu sehen ist
  );

 CREATE INDEX ks_top_ksabt ON ksv (ks_top_ksabt) WHERE ks_top_ksabt IS NOT null;

 --- Constraint  #19516
 ALTER TABLE ksv
  ADD CONSTRAINT ksv__ausw__requires__dlz
    CHECK((NOT ks_ausw) OR (coalesce( ks_dlz, 0 ) > 0));


  CREATE OR REPLACE FUNCTION ksv__b_iu() RETURNS TRIGGER AS $$
   BEGIN
    new.ks_nk  := (new.ks_ka1 + new.ks_ka2 + new.ks_ka3 + new.ks_ka4 + new.ks_ka5 + new.ks_ka6 + new.ks_ka7) * new.ks_ba;
    new.ks_kap :=  new.ks_nk * new.ks_kf / 100;
    --- Sperr-Datum setzen, wenn ks_sperr = true #9645
    IF TG_OP = 'UPDATE' THEN
       IF new.ks_sperr <> old.ks_sperr THEN
          IF  new.ks_sperr THEN
             new.ks_sperr_datum := current_date;
          ELSE
             new.ks_sperr_datum := null;
          END IF;
       END IF;
    ELSIF TG_OP = 'INSERT' THEN
       IF new.ks_sperr THEN
          new.ks_sperr_datum := current_date;
       END IF;
    END IF;
    --Überschneidet sich sonst mit Kostenstellenpool (KS -> KS /1, KS/2 ... KS/10)
    IF (new.ks_abt LIKE '%/%') THEN
      RAISE EXCEPTION '%', Format(lang_text(29171) /*'Ungueltiges Zeichen im Kostenstellenkuerzel ("/")'*/);
    END IF;
    RETURN new;
   END $$ LANGUAGE plpgsql;

   CREATE TRIGGER ksv__b_iu
    BEFORE INSERT OR UPDATE
    ON ksv
    FOR EACH ROW
    EXECUTE PROCEDURE ksv__b_iu();

  --nur Trigger, globale Funktion!
  CREATE TRIGGER ksv_delete_abk_project_structure
   AFTER DELETE
   ON ksv
   FOR EACH ROW
   EXECUTE PROCEDURE table_delete_abkstru();

   -- #7440 - Techplanparameter
  CREATE TRIGGER ksv__a_iu__create_autoparams
    AFTER INSERT OR UPDATE
    ON ksv
    FOR EACH ROW
    EXECUTE PROCEDURE TRecnoParam.CreateAutoParams();

  --- #16862
  CREATE OR REPLACE FUNCTION ksv__obsolet_column__ks_vf_group() RETURNS TRIGGER AS $$
   BEGIN
    -- falls alte Version in altes Feld schreibt, in neue übertragen
    IF tg_op = 'INSERT' THEN
       IF new.ks_kinematic_group IS NOT null THEN
          new.ks_vf_group := new.ks_kinematic_group;
       ELSIF
          new.ks_vf_group IS NOT null THEN
          new.ks_kinematic_group := new.ks_vf_group;
       END IF;
    ELSE
       IF old.ks_kinematic_group IS DISTINCT FROM new.ks_kinematic_group THEN
          new.ks_vf_group := new.ks_kinematic_group;
       ELSIF
          old.ks_vf_group IS DISTINCT FROM new.ks_vf_group THEN
          new.ks_kinematic_group := new.ks_vf_group;
       END IF;
    END IF;
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER ksv__obsolet_column__ks_vf_group
    BEFORE INSERT OR UPDATE
    OF ks_vf_group, ks_kinematic_group
    ON ksv
    FOR EACH ROW
    EXECUTE PROCEDURE ksv__obsolet_column__ks_vf_group();
  ---
CREATE TABLE ksvba (
    ksb_id            serial PRIMARY KEY, -- ti_resource_id
    ksb_ks_id         integer NOT null REFERENCES ksv ( ks_id ) ON DELETE CASCADE ON UPDATE CASCADE,
    ksb_ks_abt        varchar(9) NOT null,
    ksb_ks_ba_num     integer NOT null,
    ksb_ks_ba_babz    varchar(25),
    ksb_ks_ba         numeric(4,2) NOT null,
    ksb_ks_shorthand  varchar(12),
    ksb_timestart     time DEFAULT '08:00',
    ksb_timeend       time DEFAULT '18:00'
    CONSTRAINT max_ks_timeend CHECK ( (ksb_timeend < '24:00:00') AND (ksb_timestart < ksb_timeend) )
  );

  CREATE UNIQUE INDEX ksvba_workplace ON ksvba ( ksb_ks_id, ksb_ks_ba_num );
  CREATE INDEX ksvba_ks_abt_babz ON ksvba ( ksb_ks_abt, ksb_ks_ba_babz );
  CREATE INDEX ksvba_ks_abt_num ON ksvba ( ksb_ks_abt, ksb_ks_ba_num );
  CREATE INDEX ksvba_ks_abt ON ksvba ( ksb_ks_abt );
  CREATE INDEX ksvba_ks_ba_babz ON ksvba ( ksb_ks_ba_babz );
  CREATE INDEX ksvba_ks_id ON ksvba ( ksb_ks_id );
  CREATE INDEX ksvba_ks_shorthand ON ksvba ( ksb_ks_shorthand );

--  update ksv set ks_id = ks_id ;

  CREATE OR REPLACE FUNCTION ksv__a_iu__sync_ksv_ba() RETURNS TRIGGER AS $$
   BEGIN

       -- arbeitsplatz 1
       IF ( new.ks_ba IS NULL OR new.ks_ba = 0 ) THEN
         DELETE FROM ksvba WHERE ksb_ks_id = new.ks_id AND ksb_ks_ba_num = 1;
       ELSE

         -- replace into ksvba on updating ksv_ba
         INSERT INTO ksvba( ksb_ks_id, ksb_ks_ba_num, ksb_ks_ba_babz, ksb_ks_ba, ksb_ks_abt, ksb_ks_shorthand )
         VALUES ( new.ks_id, 1, new.ks_babz, new.ks_ba, new.ks_abt,  new.ks_abt)
         ON CONFLICT(ksb_ks_id, ksb_ks_ba_num) DO UPDATE
         SET ksb_ks_ba_babz = new.ks_babz, ksb_ks_ba = new.ks_ba, ksb_ks_abt = new.ks_abt, ksb_ks_shorthand = new.ks_abt;
       END IF;

       -- arbeitsplatz 2
       IF ( new.ks_ba1 IS NULL OR new.ks_ba1 = 0 ) THEN
         DELETE FROM ksvba WHERE ksb_ks_id = new.ks_id AND ksb_ks_ba_num = 2;
       ELSE

         -- replace into ksvba on updating ksv_ba
         INSERT INTO ksvba( ksb_ks_id, ksb_ks_ba_num, ksb_ks_ba_babz, ksb_ks_ba, ksb_ks_abt, ksb_ks_shorthand )
         VALUES ( new.ks_id, 2, new.ks_babz1, new.ks_ba1, new.ks_abt, new.ks_abt || ' /2')
         ON CONFLICT(ksb_ks_id, ksb_ks_ba_num) DO UPDATE
         SET ksb_ks_ba_babz = new.ks_babz1, ksb_ks_ba =  new.ks_ba1, ksb_ks_abt = new.ks_abt, ksb_ks_shorthand = new.ks_abt || ' /2';
       END IF;

       -- arbeitsplatz 3
       IF ( new.ks_ba2 IS NULL OR new.ks_ba2 = 0 ) THEN
         DELETE FROM ksvba WHERE ksb_ks_id = new.ks_id AND ksb_ks_ba_num = 3;
       ELSE

         -- replace into ksvba on updating ksv_ba
         INSERT INTO ksvba( ksb_ks_id, ksb_ks_ba_num, ksb_ks_ba_babz, ksb_ks_ba, ksb_ks_abt, ksb_ks_shorthand )
         VALUES ( new.ks_id, 3, new.ks_babz2, new.ks_ba2, new.ks_abt, new.ks_abt || ' /3')
         ON CONFLICT(ksb_ks_id, ksb_ks_ba_num) DO UPDATE
         SET ksb_ks_ba_babz = new.ks_babz2, ksb_ks_ba =  new.ks_ba2, ksb_ks_abt = new.ks_abt, ksb_ks_shorthand = new.ks_abt || ' /3';
       END IF;

       -- arbeitsplatz 4
       IF ( new.ks_ba3 IS NULL OR new.ks_ba3 = 0 ) THEN
         DELETE FROM ksvba WHERE ksb_ks_id = new.ks_id AND ksb_ks_ba_num = 4;
       ELSE

         -- replace into ksvba on updating ksv_ba
         INSERT INTO ksvba( ksb_ks_id, ksb_ks_ba_num, ksb_ks_ba_babz, ksb_ks_ba, ksb_ks_abt, ksb_ks_shorthand )
         VALUES ( new.ks_id, 4, new.ks_babz3, new.ks_ba3, new.ks_abt, new.ks_abt || ' /4')
         ON CONFLICT(ksb_ks_id, ksb_ks_ba_num) DO UPDATE
         SET ksb_ks_ba_babz = new.ks_babz3, ksb_ks_ba =  new.ks_ba3, ksb_ks_abt = new.ks_abt, ksb_ks_shorthand = new.ks_abt || ' /4';
       END IF;

       -- arbeitsplatz 5
       IF ( new.ks_ba4 IS NULL OR new.ks_ba4 = 0 ) THEN
         DELETE FROM ksvba WHERE ksb_ks_id = new.ks_id AND ksb_ks_ba_num = 5;
       ELSE

         -- replace into ksvba on updating ksv_ba
         INSERT INTO ksvba( ksb_ks_id, ksb_ks_ba_num, ksb_ks_ba_babz, ksb_ks_ba, ksb_ks_abt, ksb_ks_shorthand )
         VALUES ( new.ks_id, 5, new.ks_babz4, new.ks_ba4, new.ks_abt, new.ks_abt || ' /5')
         ON CONFLICT(ksb_ks_id, ksb_ks_ba_num) DO UPDATE
         SET ksb_ks_ba_babz = new.ks_babz4, ksb_ks_ba =  new.ks_ba4, ksb_ks_abt = new.ks_abt, ksb_ks_shorthand = new.ks_abt || ' /5';
       END IF;

       -- arbeitsplatz 6
       IF ( new.ks_ba5 IS NULL OR new.ks_ba5 = 0 ) THEN
         DELETE FROM ksvba WHERE ksb_ks_id = new.ks_id AND ksb_ks_ba_num = 6;
       ELSE

         -- replace into ksvba on updating ksv_ba
         INSERT INTO ksvba( ksb_ks_id, ksb_ks_ba_num, ksb_ks_ba_babz, ksb_ks_ba, ksb_ks_abt, ksb_ks_shorthand )
         VALUES ( new.ks_id, 6, new.ks_babz5, new.ks_ba5, new.ks_abt, new.ks_abt || ' /6')
         ON CONFLICT(ksb_ks_id, ksb_ks_ba_num) DO UPDATE
         SET ksb_ks_ba_babz = new.ks_babz5, ksb_ks_ba =  new.ks_ba5, ksb_ks_abt = new.ks_abt, ksb_ks_shorthand = new.ks_abt || ' /6';
       END IF;

       -- arbeitsplatz 7
       IF ( new.ks_ba6 IS NULL OR new.ks_ba6 = 0 ) THEN
         DELETE FROM ksvba WHERE ksb_ks_id = new.ks_id AND ksb_ks_ba_num = 7;
       ELSE

         -- replace into ksvba on updating ksv_ba
         INSERT INTO ksvba( ksb_ks_id, ksb_ks_ba_num, ksb_ks_ba_babz, ksb_ks_ba, ksb_ks_abt, ksb_ks_shorthand )
         VALUES ( new.ks_id, 7, new.ks_babz6, new.ks_ba6, new.ks_abt, new.ks_abt || ' /7')
         ON CONFLICT(ksb_ks_id, ksb_ks_ba_num) DO UPDATE
         SET ksb_ks_ba_babz = new.ks_babz6, ksb_ks_ba =  new.ks_ba6, ksb_ks_abt = new.ks_abt, ksb_ks_shorthand = new.ks_abt || ' /7';
       END IF;

       -- arbeitsplatz 8
       IF ( new.ks_ba7 IS NULL OR new.ks_ba7 = 0 ) THEN
         DELETE FROM ksvba WHERE ksb_ks_id = new.ks_id AND ksb_ks_ba_num = 8;
       ELSE

         -- replace into ksvba on updating ksv_ba
         INSERT INTO ksvba( ksb_ks_id, ksb_ks_ba_num, ksb_ks_ba_babz, ksb_ks_ba, ksb_ks_abt, ksb_ks_shorthand )
         VALUES ( new.ks_id, 8, new.ks_babz7, new.ks_ba7, new.ks_abt, new.ks_abt || ' /8')
         ON CONFLICT(ksb_ks_id, ksb_ks_ba_num) DO UPDATE
         SET ksb_ks_ba_babz = new.ks_babz7, ksb_ks_ba =  new.ks_ba7, ksb_ks_abt = new.ks_abt, ksb_ks_shorthand = new.ks_abt || ' /8';
       END IF;

       -- arbeitsplatz 9
       IF ( new.ks_ba8 IS NULL OR new.ks_ba8 = 0 ) THEN
         DELETE FROM ksvba WHERE ksb_ks_id = new.ks_id AND ksb_ks_ba_num = 9;
       ELSE

         -- replace into ksvba on updating ksv_ba
         INSERT INTO ksvba( ksb_ks_id, ksb_ks_ba_num, ksb_ks_ba_babz, ksb_ks_ba, ksb_ks_abt, ksb_ks_shorthand )
         VALUES ( new.ks_id, 9, new.ks_babz8, new.ks_ba8, new.ks_abt, new.ks_abt || ' /9')
         ON CONFLICT(ksb_ks_id, ksb_ks_ba_num) DO UPDATE
         SET ksb_ks_ba_babz = new.ks_babz8, ksb_ks_ba =  new.ks_ba8, ksb_ks_abt = new.ks_abt, ksb_ks_shorthand = new.ks_abt || ' /9';
       END IF;

       -- arbeitsplatz 10
       IF ( new.ks_ba9 IS NULL OR new.ks_ba9 = 0 ) THEN
         DELETE FROM ksvba WHERE ksb_ks_id = new.ks_id AND ksb_ks_ba_num = 10;
       ELSE

         -- replace into ksvba on updating ksv_ba
         INSERT INTO ksvba( ksb_ks_id, ksb_ks_ba_num, ksb_ks_ba_babz, ksb_ks_ba, ksb_ks_abt, ksb_ks_shorthand )
         VALUES ( new.ks_id, 10, new.ks_babz9, new.ks_ba9, new.ks_abt, new.ks_abt || ' /10')
         ON CONFLICT(ksb_ks_id, ksb_ks_ba_num) DO UPDATE
         SET ksb_ks_ba_babz = new.ks_babz9, ksb_ks_ba =  new.ks_ba9, ksb_ks_abt = new.ks_abt, ksb_ks_shorthand = new.ks_abt || ' /10';
       END IF;

       -- arbeitsplatz 11
       IF ( new.ks_ba10 IS NULL OR new.ks_ba10 = 0 ) THEN
         DELETE FROM ksvba WHERE ksb_ks_id = new.ks_id AND ksb_ks_ba_num = 11;
       ELSE

         -- replace into ksvba on updating ksv_ba
         INSERT INTO ksvba( ksb_ks_id, ksb_ks_ba_num, ksb_ks_ba_babz, ksb_ks_ba, ksb_ks_abt, ksb_ks_shorthand )
         VALUES ( new.ks_id, 11, new.ks_babz10, new.ks_ba10, new.ks_abt, new.ks_abt || ' /11')
         ON CONFLICT(ksb_ks_id, ksb_ks_ba_num) DO UPDATE
         SET ksb_ks_ba_babz = new.ks_babz10, ksb_ks_ba =  new.ks_ba10, ksb_ks_abt = new.ks_abt, ksb_ks_shorthand = new.ks_abt || ' /11';
       END IF;

       -- arbeitsplatz 12
       IF ( new.ks_ba11 IS NULL OR new.ks_ba11 = 0 ) THEN
         DELETE FROM ksvba WHERE ksb_ks_id = new.ks_id AND ksb_ks_ba_num = 12;
       ELSE

         -- replace into ksvba on updating ksv_ba
         INSERT INTO ksvba( ksb_ks_id, ksb_ks_ba_num, ksb_ks_ba_babz, ksb_ks_ba, ksb_ks_abt, ksb_ks_shorthand )
         VALUES ( new.ks_id, 12, new.ks_babz11, new.ks_ba11, new.ks_abt, new.ks_abt || ' /12')
         ON CONFLICT(ksb_ks_id, ksb_ks_ba_num) DO UPDATE
         SET ksb_ks_ba_babz = new.ks_babz11, ksb_ks_ba =  new.ks_ba11, ksb_ks_abt = new.ks_abt, ksb_ks_shorthand = new.ks_abt || ' /12';
       END IF;

       -- arbeitsplatz 13
       IF ( new.ks_ba12 IS NULL OR new.ks_ba12 = 0 ) THEN
         DELETE FROM ksvba WHERE ksb_ks_id = new.ks_id AND ksb_ks_ba_num = 13;
       ELSE

         -- replace into ksvba on updating ksv_ba
         INSERT INTO ksvba( ksb_ks_id, ksb_ks_ba_num, ksb_ks_ba_babz, ksb_ks_ba, ksb_ks_abt, ksb_ks_shorthand )
         VALUES ( new.ks_id, 13, new.ks_babz12, new.ks_ba12, new.ks_abt, new.ks_abt || ' /13')
         ON CONFLICT(ksb_ks_id, ksb_ks_ba_num) DO UPDATE
         SET ksb_ks_ba_babz = new.ks_babz12, ksb_ks_ba =  new.ks_ba12, ksb_ks_abt = new.ks_abt, ksb_ks_shorthand = new.ks_abt || ' /13';
       END IF;

       -- arbeitsplatz 14
       IF ( new.ks_ba13 IS NULL OR new.ks_ba13 = 0 ) THEN
         DELETE FROM ksvba WHERE ksb_ks_id = new.ks_id AND ksb_ks_ba_num = 14;
       ELSE

         -- replace into ksvba on updating ksv_ba
         INSERT INTO ksvba( ksb_ks_id, ksb_ks_ba_num, ksb_ks_ba_babz, ksb_ks_ba, ksb_ks_abt, ksb_ks_shorthand )
         VALUES ( new.ks_id, 14, new.ks_babz13, new.ks_ba13, new.ks_abt, new.ks_abt || ' /14')
         ON CONFLICT(ksb_ks_id, ksb_ks_ba_num) DO UPDATE
         SET ksb_ks_ba_babz = new.ks_babz13, ksb_ks_ba =  new.ks_ba13, ksb_ks_abt = new.ks_abt, ksb_ks_shorthand = new.ks_abt || ' /14';
       END IF;

       -- arbeitsplatz 15
       IF ( new.ks_ba14 IS NULL OR new.ks_ba14 = 0 ) THEN
         DELETE FROM ksvba WHERE ksb_ks_id = new.ks_id AND ksb_ks_ba_num = 15;
       ELSE

         -- replace into ksvba on updating ksv_ba
         INSERT INTO ksvba( ksb_ks_id, ksb_ks_ba_num, ksb_ks_ba_babz, ksb_ks_ba, ksb_ks_abt, ksb_ks_shorthand )
         VALUES ( new.ks_id, 15, new.ks_babz14, new.ks_ba14, new.ks_abt, new.ks_abt || ' /15')
         ON CONFLICT(ksb_ks_id, ksb_ks_ba_num) DO UPDATE
         SET ksb_ks_ba_babz = new.ks_babz14, ksb_ks_ba =  new.ks_ba14, ksb_ks_abt = new.ks_abt, ksb_ks_shorthand = new.ks_abt || ' /15';
       END IF;

       -- arbeitsplatz 16
       IF ( new.ks_ba15 IS NULL OR new.ks_ba15 = 0 ) THEN
         DELETE FROM ksvba WHERE ksb_ks_id = new.ks_id AND ksb_ks_ba_num = 16;
       ELSE

         -- replace into ksvba on updating ksv_ba
         INSERT INTO ksvba( ksb_ks_id, ksb_ks_ba_num, ksb_ks_ba_babz, ksb_ks_ba, ksb_ks_abt, ksb_ks_shorthand )
         VALUES ( new.ks_id, 16, new.ks_babz15, new.ks_ba15, new.ks_abt, new.ks_abt || ' /16')
         ON CONFLICT(ksb_ks_id, ksb_ks_ba_num) DO UPDATE
         SET ksb_ks_ba_babz = new.ks_babz15, ksb_ks_ba =  new.ks_ba15, ksb_ks_abt = new.ks_abt, ksb_ks_shorthand = new.ks_abt || ' /16';
       END IF;

       -- arbeitsplatz 17
       IF ( new.ks_ba16 IS NULL OR new.ks_ba16 = 0 ) THEN
         DELETE FROM ksvba WHERE ksb_ks_id = new.ks_id AND ksb_ks_ba_num = 17;
       ELSE

         -- replace into ksvba on updating ksv_ba
         INSERT INTO ksvba( ksb_ks_id, ksb_ks_ba_num, ksb_ks_ba_babz, ksb_ks_ba, ksb_ks_abt, ksb_ks_shorthand )
         VALUES ( new.ks_id, 17, new.ks_babz16, new.ks_ba16, new.ks_abt, new.ks_abt || ' /17')
         ON CONFLICT(ksb_ks_id, ksb_ks_ba_num) DO UPDATE
         SET ksb_ks_ba_babz = new.ks_babz16, ksb_ks_ba =  new.ks_ba16, ksb_ks_abt = new.ks_abt, ksb_ks_shorthand = new.ks_abt || ' /17';
       END IF;

        -- arbeitsplatz 18
       IF ( new.ks_ba17 IS NULL OR new.ks_ba17 = 0 ) THEN
         DELETE FROM ksvba WHERE ksb_ks_id = new.ks_id AND ksb_ks_ba_num = 18;
       ELSE

         -- replace into ksvba on updating ksv_ba
         INSERT INTO ksvba( ksb_ks_id, ksb_ks_ba_num, ksb_ks_ba_babz, ksb_ks_ba, ksb_ks_abt, ksb_ks_shorthand )
         VALUES ( new.ks_id, 18, new.ks_babz17, new.ks_ba17, new.ks_abt, new.ks_abt || ' /18')
         ON CONFLICT(ksb_ks_id, ksb_ks_ba_num) DO UPDATE
         SET ksb_ks_ba_babz = new.ks_babz17, ksb_ks_ba =  new.ks_ba17, ksb_ks_abt = new.ks_abt, ksb_ks_shorthand = new.ks_abt || ' /18';
       END IF;

       -- arbeitsplatz 19
       IF ( new.ks_ba18 IS NULL OR new.ks_ba18 = 0 ) THEN
         DELETE FROM ksvba WHERE ksb_ks_id = new.ks_id AND ksb_ks_ba_num = 19;
       ELSE

         -- replace into ksvba on updating ksv_ba
         INSERT INTO ksvba( ksb_ks_id, ksb_ks_ba_num, ksb_ks_ba_babz, ksb_ks_ba, ksb_ks_abt, ksb_ks_shorthand )
         VALUES ( new.ks_id, 19, new.ks_babz18, new.ks_ba18, new.ks_abt, new.ks_abt || ' /19')
         ON CONFLICT(ksb_ks_id, ksb_ks_ba_num) DO UPDATE
         SET ksb_ks_ba_babz = new.ks_babz18, ksb_ks_ba =  new.ks_ba18, ksb_ks_abt = new.ks_abt, ksb_ks_shorthand = new.ks_abt || ' /19';
       END IF;

       -- arbeitsplatz 20
       IF ( new.ks_ba19 IS NULL OR new.ks_ba19 = 0 ) THEN
         DELETE FROM ksvba WHERE ksb_ks_id = new.ks_id AND ksb_ks_ba_num = 20;
       ELSE

         -- replace into ksvba on updating ksv_ba
         INSERT INTO ksvba( ksb_ks_id, ksb_ks_ba_num, ksb_ks_ba_babz, ksb_ks_ba, ksb_ks_abt, ksb_ks_shorthand )
         VALUES ( new.ks_id, 20, new.ks_babz19, new.ks_ba19, new.ks_abt, new.ks_abt || ' /20')
         ON CONFLICT(ksb_ks_id, ksb_ks_ba_num) DO UPDATE
         SET ksb_ks_ba_babz = new.ks_babz19, ksb_ks_ba =  new.ks_ba19, ksb_ks_abt = new.ks_abt, ksb_ks_shorthand = new.ks_abt || ' /20';
       END IF;

       return new;
   END $$ language plpgsql;

  CREATE TRIGGER ksv__a_iu__sync_ksv_ba
    AFTER INSERT OR UPDATE
    ON ksv
    FOR EACH ROW
  EXECUTE PROCEDURE public.ksv__a_iu__sync_ksv_ba();

 CREATE OR REPLACE FUNCTION ksv__a_d__sync_ksv_delete() RETURNS TRIGGER AS $$
   BEGIN
     DELETE FROM ksvba WHERE ksb_ks_id = old.ks_id;
   RETURN new;
   END $$ LANGUAGE plpgsql;


  CREATE TRIGGER ksv__a_d__sync_ksv_delete
    AFTER DELETE
    ON ksv
    FOR EACH ROW
  EXECUTE PROCEDURE public.ksv__a_d__sync_ksv_delete();


-- Tabelle für das Speichern von Stundensätzen
CREATE TABLE ksv_stundensatz_art (

  -- technische ID
  kssa_id                           serial PRIMARY KEY,

  -- Referenz zur Kostenstelle
  kssa_ks_abt                       varchar(9) NOT null     REFERENCES ksv ( ks_abt ) ON UPDATE CASCADE ON DELETE CASCADE,

  -- Referenz zum Artikel
  kssa_ak_nr                        varchar(40) NOT null    REFERENCES art ( ak_nr ) ON UPDATE CASCADE ON DELETE CASCADE,

  -- der normale Stundensatz
  kssa_sts                          numeric(12,4)           CONSTRAINT kssa_sts_not_negative  CHECK ( kssa_sts >= 0 ),

  -- der Stundensatz für das Rüsten
  kssa_stsr                         numeric(12,4)           CONSTRAINT kssa_stsr_not_negative CHECK ( kssa_stsr >= 0 ),

  -- der Stundensatz für die Bedienung
  kssa_stsm                         numeric(12,4)           CONSTRAINT kssa_stsm_not_negative CHECK ( kssa_stsm >= 0 ),

  -- der Grenzstundensatz
  kssa_gss                          numeric(12,4)           CONSTRAINT kssa_gss_not_negative  CHECK ( kssa_gss  >= 0 ),

  -- der Grenzstundensatz für das Rüsten
  kssa_gssr                         numeric(12,4)           CONSTRAINT kssa_gssr_not_negative CHECK ( kssa_gssr >= 0 ),

  -- der Grenzstundensatz für die Bedienung
  kssa_gssm                         numeric(12,4)           CONSTRAINT kssa_gssm_not_negative CHECK ( kssa_gssm >= 0 ),

  -- optionale Bemerkung
  kssa_bemerkung                    text,

  -- zumindest ein Stundensatz muss gesetzt sein
  CONSTRAINT kssa_sts_not_all_null CHECK (
      NOT (
               kssa_sts  IS null
           AND kssa_stsr IS null
           AND kssa_stsm IS null
           AND kssa_gss  IS null
           AND kssa_gssr IS null
           AND kssa_gssm IS null
      )
  )
);

-- nur ein Datensatz je Artikel
CREATE UNIQUE INDEX ksv_stundensatz_art__kssa_ks_abt__kssa_ak_nr
  ON ksv_stundensatz_art( kssa_ks_abt, kssa_ak_nr );


CREATE TABLE op5txt    --Zusatztext für Kostenstellen hinterlegt
  (o5t_id               SERIAL PRIMARY KEY,
   o5t_kst              VARCHAR(9) NOT NULL REFERENCES ksv ON UPDATE CASCADE ON DELETE CASCADE,
   o5t_nr               INTEGER NOT NULL,
   o5t_txm              TEXT
  );


  -- Kostenstelle-Werkzeugzuordnung
CREATE TABLE ksv_werkzeuge (
  ksw_id SERIAL PRIMARY KEY,
  ksw_ks_abt     VARCHAR(9)      REFERENCES ksv ON UPDATE CASCADE ON DELETE CASCADE,    -- Kostenstelletabelle
  ksw_ak_nr      VARCHAR(40)     REFERENCES art ON UPDATE CASCADE ON DELETE CASCADE,    -- Artikeltabelle
  ksw_txt              TEXT,
  ksw_txt_rtf          TEXT
);
---

 /*Maschinenstundensatzberechnung*/

 CREATE TABLE maschko
  (mk_id                SERIAL PRIMARY KEY,
   mk_kst               VARCHAR(9) NOT NULL REFERENCES ksv,
   mk_std               NUMERIC NOT NULL,/*Artbeitsstunden pro Woche*/
   mk_kpk               NUMERIC NOT NULL,/*Korrekturfaktor*/
   mk_gww               NUMERIC NOT NULL,/*Aufschlag Gewinn und Wagniss*/
   mk_bpr               NUMERIC,/*Beschaffungspreis*/
   mk_ndm               NUMERIC, /*Nutzungsdauer Maschine*/
   mk_trr               NUMERIC,/*Teuerungsrate*/
   mk_zpr               NUMERIC,/*Zubehörpreis*/
   mk_ndz               NUMERIC,/*Nutzerungsdauer Zubehör*/
   mk_zss               NUMERIC,/*Zinssatz*/
   mk_mnf               NUMERIC,/*MaschineNutztFläche*/
   mk_mpr               NUMERIC,/*Mietpreis*/
   mk_kwh               NUMERIC,/*Maschine Ernergiebedarf*/
   mk_spr               NUMERIC,/*Energiepreis*/
   mk_saz               SMALLINT,/*Instandhaltungskosten - Anzahl Schichten*/
   mk_kfl               NUMERIC,/*Kosten Fehlleistungen*/
   mk_ksk               NUMERIC,/*Schmier und Kühlmittel*/
   mk_kwz               NUMERIC,/*Werkzeugkosten*/
   mk_krr               NUMERIC,/*Raumerhaltung Reinigung*/
   mk_khs               NUMERIC,/*Hilfsstoffe*/
   mk_kas               NUMERIC,/*Arbeitsschutz*/
   mk_khy               NUMERIC,/*Kosten hygiene*/
   mk_kpm               NUMERIC,/*Prüfmittel*/
   mk_lkq               NUMERIC,/*Stundensatz Qualitätssicherung*/
   mk_qpz               NUMERIC,/*Zeit für Prüfung ausserhalb der Maschine*/
   mk_enr               BOOL NOT NULL DEFAULT FALSE,/*Einrichter Ja/Nein*/
   mk_mmb               SMALLINT,/*Mehrmschinenbedienung, Anzahl Maschinen*/
   mk_lke               NUMERIC,/*Stundensatz Einrichter*/
   mk_lkb               NUMERIC,/*Stundensatz Bediener*/
   mk_lkz               NUMERIC,/*Zusätzliche Lohnkosten*/
   mk_skz               NUMERIC,/*Zusätzliche Sozialleistungen*/
   mk_kvt               NUMERIC,/*Vertriebskosten*/
   mk_vww               NUMERIC,/*Vertwaltungskosten in*/
   mk_abschr            BOOL NOT NULL DEFAULT TRUE,
   mk_zins              BOOL NOT NULL DEFAULT TRUE,
   mk_raum              BOOL NOT NULL DEFAULT TRUE,
   mk_energie           BOOL NOT NULL DEFAULT FALSE,
   mk_inst              BOOL NOT NULL DEFAULT FALSE,
   mk_quali             BOOL NOT NULL DEFAULT FALSE,
   mk_neben             BOOL NOT NULL DEFAULT FALSE,
   mk_ferloko           BOOL NOT NULL DEFAULT FALSE,
   mk_ruestloko         BOOL NOT NULL DEFAULT FALSE,
   mk_vverwalt          BOOL NOT NULL DEFAULT FALSE,
   mk_gssfakt_abschr            NUMERIC DEFAULT 1,
   mk_gssfakt_zins              NUMERIC DEFAULT 1,
   mk_gssfakt_raum              NUMERIC DEFAULT 1,
   mk_gssfakt_energie           NUMERIC DEFAULT 1,
   mk_gssfakt_inst              NUMERIC DEFAULT 1,
   mk_gssfakt_neben             NUMERIC DEFAULT 1,
   mk_gssfakt_quali             NUMERIC DEFAULT 1,
   mk_gssfakt_ferloko           NUMERIC DEFAULT 1,
   mk_gssfakt_ruestloko         NUMERIC DEFAULT 1,
   mk_gssfakt_vverwalt          NUMERIC DEFAULT 1
  );

 /*Teilestati*/

 CREATE TABLE oplstat
  (os_stat              VARCHAR(3) CONSTRAINT xtt4099 PRIMARY KEY,
   os_bez               VARCHAR(50)
  );

-- ASK - Stammtabelle ( TABLE ask )
CREATE TABLE opl (
  op_n                 VARCHAR(40) NOT NULL REFERENCES art ON UPDATE CASCADE,    -- Artikelnummer
  op_ix                SERIAL NOT NULL PRIMARY KEY,                                                 -- ASK-index
  op_vi                VARCHAR(3) NOT NULL,                                                         -- Variante
  op_vit               VARCHAR(50),                                                                 -- Varianten-Bezeichnung
  op_stat              VARCHAR(3) REFERENCES oplstat,                            -- Teilestatus
  op_lg                NUMERIC NOT NULL DEFAULT 1,                                                  -- Fertigungslosgröße
  op_agk               NUMERIC NOT NULL DEFAULT 0,                                                  -- Auswärtsgemeinkosten
  op_mgk               NUMERIC NOT NULL DEFAULT 0,                                                  -- Materialgemeinkosten
  op_rgk               NUMERIC NOT NULL DEFAULT 0,                                                  -- Rüstkostenzuschlage
  op_fgk               NUMERIC NOT NULL DEFAULT 0,                                                  -- Fertigungsgemeinkosten
  op_txt               TEXT,                                                                        -- Hinweistext zur Variante
  op_txt_rtf           TEXT,
  op_quali             TEXT,
  op_quali_rtf         TEXT,
  op_pruef             TEXT,
  op_pruef_rtf         TEXT,
  op_standard          BOOL DEFAULT true,                                                           -- Fertigungsvariante
  op_kalku             BOOL DEFAULT true,                                                           -- Kalkulationsvariante
  op_mp_insert_date    DATE,                                                                        -- Messplan
  op_mp_modified_date  DATE,
  op_mp_insert_by      VARCHAR,
  op_mp_modified_by    VARCHAR,
  op_qs_freigabe       BOOL,                                                                        -- Freigabe durch QS. Achtung NULL-Status wird für Assistent genutzt
  op_aknr_src          VARCHAR(40)                                                                  -- diese AVOR wurde kopiert von
);

SELECT setval('opl_op_ix_seq', 10000);

-- Indizes
    CREATE UNIQUE INDEX xtt2069 ON opl(op_n, op_standard) WHERE op_standard;
    CREATE INDEX opl_op_n_like ON opl(op_n varchar_pattern_ops);
    CREATE INDEX opl_standard_aknr_index ON opl (op_n, op_standard);
    CREATE UNIQUE INDEX opl_aknr_variante ON opl (op_n, op_vi);
--

--
CREATE OR REPLACE FUNCTION opl__b_iu() RETURNS TRIGGER AS $$
  DECLARE otherIsKalkVar BOOLEAN;
  BEGIN
    IF new.op_standard THEN
        UPDATE opl SET op_standard=FALSE WHERE op_n=new.op_n AND op_ix<>new.op_ix AND op_standard RETURNING op_kalku INTO otherIsKalkVar;
        IF otherIsKalkVar -- alte Fertigungsvariante war auch Kalkulationsvariante, dann wird diese jetzt mit umgesetzt.
            OR NOT EXISTS(SELECT true FROM opl WHERE op_n=new.op_n AND op_kalku) -- oder es gibt (noch) keine Kalkulationsvariante
        THEN
            new.op_kalku:=True;
        END IF;
    END IF;
    IF new.op_kalku THEN
        UPDATE opl SET op_kalku=FALSE WHERE op_n=new.op_n AND op_ix<>new.op_ix AND op_kalku;
    END IF;
    IF new.op_lg<=0 THEN
          new.op_lg:=1;
    END IF;
    --setzen ak_fertigung in opl__a_iu
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER opl__b_iu
    BEFORE INSERT OR UPDATE
    ON opl
    FOR EACH ROW
    EXECUTE PROCEDURE opl__b_iu();
--

-- Globale Zuschlagskalkulation mit Vorgaben füllen, falls krc_autoinsert; #8003
CREATE OR REPLACE FUNCTION opl__a_i_90() RETURNS TRIGGER AS $$
  BEGIN
    -- Globale Zuschlagskalkulation mit Vorgaben füllen, falls krc_autoinsert
    INSERT INTO op7zko
      (o7zk_ix,              --REFERENCES opl
       o7zk_krc_bez,         --Bezeichnung
       o7zk_proz)            --Prozent
    SELECT
       new.op_ix,
       krc_bez,
       krc_proz
    FROM
       kostrechgemko
    WHERE
       krc_autoinsert;

    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER opl__a_i_90
  AFTER INSERT
  ON public.opl
  FOR EACH ROW
  EXECUTE PROCEDURE public.opl__a_i_90();
--

--
CREATE OR REPLACE FUNCTION opl__a_iu() RETURNS TRIGGER AS $$
  BEGIN
    IF TSystem.Settings__Get('disable_handle_opreg')='T' THEN -- Es wird nur das Bearbeitungsdatum umgesetzt.
        RETURN new;
    END IF;

    PERFORM handle_opreg(new.op_ix, NULL, 'opl', null);

    IF new.op_standard THEN -- ak_fertigung setzen, falls nicht gesetzt.
        PERFORM disablemodified();
        UPDATE art SET ak_fertigung=TRUE WHERE NOT ak_fertigung AND ak_nr=new.op_n;
        PERFORM enablemodified();
    END IF;

    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER opl__a_iu
    AFTER INSERT OR UPDATE
    ON opl
    FOR EACH ROW
    EXECUTE PROCEDURE opl__a_iu();
--

-- Globale Suchfenster aus ASK
CREATE OR REPLACE FUNCTION opl__a_iud_keywordsearch() RETURNS TRIGGER AS $$
  BEGIN
    IF TG_OP = 'DELETE' THEN
        PERFORM TSystem.kws_create_keywords(art) FROM art WHERE ak_nr = old.op_n;
    ELSE
        PERFORM TSystem.kws_create_keywords(art) FROM art WHERE ak_nr = new.op_n;
    END IF;
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER opl__a_iud_keywordsearch
    AFTER INSERT OR DELETE OR UPDATE
    OF op_ix, op_n
    ON opl
    FOR EACH ROW
    EXECUTE PROCEDURE opl__a_iud_keywordsearch();
--

-- Prüfplan einfügen
 CREATE OR REPLACE FUNCTION opl_autopruefplan(IN in_opix INTEGER, IN in_aknorm VARCHAR, IN obsolete BOOLEAN, IN sendmessage BOOLEAN DEFAULT TRUE) RETURNS VOID AS $$
  DECLARE message VARCHAR;
          artnr VARCHAR;
          variant VARCHAR;
  BEGIN
    artnr:=(SELECT op_n FROM opl WHERE op_ix = in_opix);
    variant:=(SELECT op_vi FROM opl WHERE op_ix = in_opix);

    IF in_aknorm = 'DIN EN 9100' AND NOT obsolete THEN
        IF EXISTS(SELECT TRUE FROM art WHERE ak_norm = in_aknorm AND ak_nr = artnr) AND
        EXISTS(SELECT TRUE FROM oplstat WHERE os_stat = 'E') THEN
            -- Falls Prüfplan E schon vorhanden ist, entspr. der Norm aktivieren und aktualisieren.
            UPDATE op8 SET
              o8_active = TRUE,
              o8_validmonthdlv = 24,
              o8_expdatedlv = (SELECT (MAX(l_ldat)+24*'1 month'::INTERVAL-'1 day'::INTERVAL) FROM lifsch JOIN opl ON op_n=l_aknr
                               WHERE op_ix=in_opix AND op_standard AND EXISTS(SELECT TRUE FROM abk WHERE ab_askix=in_opix)) -- wurde mit der ASK schonmal gefertigt, dann Lieferdatum holen; bei neuen ASK Prüfdatum verhindern
            WHERE o8_ix = in_opix
              AND o8_op_stat = 'E';

            IF NOT FOUND THEN -- Prüfplan ist noch nicht vorhanden.
                INSERT INTO op8 (o8_ix, o8_pos, o8_op_stat, o8_validmonthdlv, o8_expdatedlv)
                SELECT in_opix, (SELECT COALESCE(MAX(o8_pos)+1, 1) FROM op8 WHERE o8_ix = in_opix), 'E', 24,
                    (SELECT (MAX(l_ldat)+24*'1 month'::INTERVAL-'1 day'::INTERVAL) FROM lifsch JOIN opl ON op_n=l_aknr
                     WHERE op_ix=in_opix AND op_standard AND EXISTS(SELECT TRUE FROM abk WHERE ab_askix=in_opix)) -- wurde mit der ASK schonmal gefertigt, dann Lieferdatum holen; bei neuen ASK Prüfdatum verhindern
                WHERE NOT EXISTS(SELECT TRUE FROM op8 WHERE o8_ix = in_opix AND o8_op_stat = 'E');
            END IF;
        END IF;
    END IF;

    IF sendmessage THEN
        IF NOT obsolete AND FOUND THEN -- FOUND vom INSERT INTO op8
            -- Prüfplan gemäß Fertigungsnorm wurde in die AVOR-Stammkarte eingefügt. + Artikelnummer:  Variante: ASK-Index: Fertigungsnorm:
            message:=langtext(16181)||E'\n\n'||langtext(234)||': '||artnr||E'\n'||langtext(782)||': '||variant||E'\n'||
                langtext(245)||': '||in_opix||E'\n'||langtext(4220)||': '||in_aknorm;
        ELSIF obsolete THEN
            -- Prüfplan gemäß Fertigungsnorm in der AVOR-Stammkarte vorhanden (keine automatische Löschung). + Artikelnummer:  Variante: ASK-Index: Fertigungsnorm:
            message:=langtext(16182)||E'\n\n'||langtext(234)||': '||artnr||E'\n'||langtext(782)||': '||variant||E'\n'||
                langtext(245)||': '||in_opix||E'\n'||langtext(4220)||': '||in_aknorm;
        END IF;

        PERFORM PRODAT_TEXT(message) WHERE message IS NOT NULL;
    END IF;

    RETURN;
  END $$ LANGUAGE plpgsql VOLATILE;
--

--
CREATE OR REPLACE FUNCTION opl__a_i_autopruefplan() RETURNS TRIGGER AS $$
  BEGIN
    -- Prüfung nach DIN EN 9100 24 Monate nach letzter Lieferung
    PERFORM opl_autopruefplan(new.op_ix, 'DIN EN 9100', FALSE);
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER opl__a_i_autopruefplan
    AFTER INSERT
    ON opl
    FOR EACH ROW
    EXECUTE PROCEDURE opl__a_i_autopruefplan();
--

-- Standard/Fertigungs variante eines Producktionsartikels => ABK erstellen
    CREATE OR REPLACE VIEW opl_standard AS SELECT * FROM opl WHERE op_standard;
--

-- Tabelle zur Verwaltung der generierten NCP-Nummern auf Basis der KS
CREATE TABLE messprogram (
    -- ID
    msp_id               serial PRIMARY KEY,
    -- Präfix der Messprogrammnummer
    msp_prefix           varchar(10),
    -- Suffix der Messprogrammnummer
    msp_suffix           integer,
    -- Nummer des Messprogramms = msp_prefix + <laufende Nummer> + msp_suffix
    msp_ncnr             varchar(20) NOT null UNIQUE,
    -- Kostenstelle des Programms
    msp_ks               varchar(9) NOT NULL REFERENCES ksv ( ks_abt ) ON UPDATE CASCADE ON DELETE CASCADE,
    -- Bemerkung
    msp_txt              text
);

COMMENT ON TABLE messprogram IS 'Tabelle zur Ablage der generierten Nummern von Messprogrammen auf Basis der KS';
--

-- ASK-Arbeitsgänge
CREATE TABLE op2 (
  o2_id                SERIAL PRIMARY KEY,
  o2_ix                INTEGER REFERENCES opl ON UPDATE CASCADE ON DELETE CASCADE,
  o2_n                 SMALLINT NOT NULL,                            -- Arbeitsgang
  o2_gewicht           NUMERIC(12,4),
  o2_as                BOOLEAN NOT NULL DEFAULT FALSE,
  o2_ul                NUMERIC,                                      -- Überlappung (0..100%)
  o2_txt_intern        TEXT,
  o2_txt               TEXT CONSTRAINT xtt5010 NOT NULL,
  o2_plantxt           TEXT,
  o2_txt_rtf           TEXT,
  o2_rustinfo          TEXT,
  o2_aw                BOOLEAN NOT NULL DEFAULT FALSE,               -- Flag dass der Arbeitsgang eine Auswärtsbearbeitung ist
  o2_aknr              VARCHAR(40) REFERENCES art ON UPDATE CASCADE, -- Arbeitspakete-Nummer
  o2_awtx              VARCHAR(100),                                 -- Bezeichnung des Arbeitspakets (also quasi o2_akbez, nur falsch benannt)
  o2_adkrz             VARCHAR(30) REFERENCES adressen_keys ON UPDATE CASCADE, -- Vorschlagener Auswärtsbearbeiter (z.Bsp. aus Kostenstelle)

  -- Zeiteinheitein (1=Stunden ; 2=Minuten ; 3=Sekunden ; 4=Tage ( entspricht 8 stunden , siehe tabelle zeinh und deren standardwerte ) )
  o2_zeinh_tr          INTEGER DEFAULT 1 NOT NULL REFERENCES zeinh,  -- Rüstzeit
  o2_zeinh_tx          INTEGER DEFAULT 2 NOT NULL REFERENCES zeinh,  -- Hauptzeit

  o2_mav               VARCHAR(4),
  --Kostenstellen und Alternativen
  o2_nc                VARCHAR(20),                                  -- NC-Programm-Nr.
  o2_ks                VARCHAR(9) NOT NULL REFERENCES ksv ON UPDATE CASCADE,
  --o2_ap              VARCHAR(20),                    --GERLACH: Entfernt, das Feld sollte sicher o2_ksap werden (analog ab2 und nk2), wird als o2_ap niemals irgendwo überhaupt nirgends verwendet nicht.
  o2_dlz               NUMERIC(10,2),                  --GÉRLACH: Nachgetragen, wird in DBUpdate erstellt, in Funktionen verwendet, fehlte aber hier noch
  o2_ksap              VARCHAR(50),                    --Kostenstelle/Arbeitsplatz
  o2_v_ll_dbusename    VARCHAR(20),                    --zuständiger Mitarbeiter!
  o2_tr                NUMERIC(12,4) NOT NULL DEFAULT 0, -- Rüstzeit je Zeiteinheit Rüsten
  o2_tr_sek            NUMERIC,                          --     "    in Sekunden
  o2_th                NUMERIC(12,4) NOT NULL DEFAULT 0, -- Hauptzeit je Zeiteinheit
  o2_th_sek            NUMERIC,                          --     "     in Sekunden
  o2_tm                NUMERIC(12,4) NOT NULL DEFAULT 0, -- Mitarbeiter/Personalzeit parallel je Zeiteinheit #7438
  o2_tm_sek            NUMERIC,                          --                "                  in Sekunden
  o2_tn                NUMERIC(12,4) NOT NULL DEFAULT 0, -- Nebenzeit je Zeiteinheit (Einzelzeit=Rüstzeit/Losgröße+(Hauptzeit+Nebenezeit)*Losgröße
  o2_tn_sek            NUMERIC,                          --     "     in Sekunden
  o2_sts               NUMERIC(12,4),                  --überschriebener Stundensatz
  o2_maschauto_ta      NUMERIC(8,4),                   --Maximale Mannloslaufzeit des Arbeitsgangs
  --
  o2_tv                NUMERIC NOT NULL DEFAULT 0,     -- prozentuale Verteilzeit
  o2_lgz               NUMERIC NOT NULL DEFAULT 0,
  o2_lgz_sek           NUMERIC,
  --
  o2_min               NUMERIC NOT NULL DEFAULT 0,
  o2_awpreisfix        NUMERIC(12,2) NOT NULL DEFAULT 0,
  o2_awpreis           NUMERIC NOT NULL DEFAULT 0,
  o2_preis_table       VARCHAR(40),
  o2_preis_dbrid       VARCHAR(40),
  o2_todotxt           TEXT,
  o2_fert_prozess      VARCHAR(50), -- Zugeordnete Fertigungsprozess für Techplan-Berechnungen

  -- Referenz zum zugeordneten Messprogramm
  o2_msp_id            integer REFERENCES messprogram ON UPDATE CASCADE
 );

 -- Indizes
    CREATE UNIQUE INDEX xtt5004 ON op2 (o2_ix, o2_n);/*jede Arbeitsgangnummer nur einmal pro ASK zulassen*/
    CREATE INDEX op2_makeganttid ON op2(makeganttopixid(o2_ix, o2_n));--verwendung: Erstellen von Netzplänen Projektmanagement
 --
 --- Constraint  #19516
 ALTER TABLE op2
  ADD CONSTRAINT op2__ausw__requires__dlz
    CHECK((NOT o2_aw) OR (coalesce( o2_dlz, 0 ) > 0));

  -- removes invalid ksaps
 CREATE OR REPLACE FUNCTION op2__b_iu__validate_ksap() RETURNS TRIGGER AS $$
    BEGIN
        IF NOT ( array[new.o2_ksap]::varchar[] && tplanterm.ksv__ksaps__fetch( new.o2_ks ) ) THEN
            new.o2_ksap := NULL;
        END IF;

        RETURN new;
    END $$ LANGUAGE plpgsql;


 CREATE TRIGGER op2__b_iu__validate_ksap
   BEFORE UPDATE
   OF o2_ks
   ON op2
   FOR EACH ROW
   WHEN ( old.o2_ks IS DISTINCT FROM new.o2_ks )
   EXECUTE PROCEDURE op2__b_iu__validate_ksap();

 -- #7440 - Techplanparameter
 CREATE TRIGGER op2__a_iu__create_autoparams
  AFTER INSERT OR UPDATE
  ON op2
  FOR EACH ROW
  EXECUTE PROCEDURE TRecnoParam.CreateAutoParams();
 --

CREATE OR REPLACE FUNCTION op2__zeinh__map( _zeinh integer ) RETURNS integer AS $$

  SELECT
    CASE _zeinh
      WHEN 1 THEN 3600
      WHEN 2 THEN 60
      WHEN 3 THEN 1
      WHEN 4 THEN 28800
      ELSE null
    END;

$$ LANGUAGE sql STRICT IMMUTABLE;

--
CREATE OR REPLACE FUNCTION op2__b10_iu() RETURNS TRIGGER AS $$
  DECLARE zeinhr INTEGER;
          zeinhx INTEGER;
          kssperr BOOLEAN;
  BEGIN
    --
    IF current_user NOT IN ('syncro', 'postgres') THEN
        kssperr:= ks_sperr FROM ksv WHERE ks_abt = new.o2_ks;
        IF kssperr THEN
            PERFORM PRODAT_ERROR('xtt10203: ' || new.o2_ks);
        END IF;
    END IF;

    -- Prüfung ob Auswärts-Arbeitspaket angegeben, wenn das per Sys.Einstellung verlangt wird.
    IF new.o2_aw THEN -- auswärts
        IF TSystem.Settings__GetBool('AWKAT') AND COALESCE(new.o2_aknr, '') = '' THEN
            RAISE EXCEPTION '%', lang_text(12654) || new.o2_ix || ', ' || new.o2_n || ' )';
        END IF;
    END IF;

    --
    IF tg_op = 'UPDATE' THEN
        IF new.o2_n <> old.o2_n THEN
            UPDATE op6 SET o6_o2_n = new.o2_n WHERE o6_o2_n = old.o2_n AND o6_ix = new.o2_ix;
        END IF;
    END IF;
    --
    zeinhr:= op2__zeinh__map( new.o2_zeinh_tr );
    zeinhx:= op2__zeinh__map( new.o2_zeinh_tx );
    --
    new.o2_tr_sek:=   new.o2_tr * zeinhr;
    new.o2_th_sek:=   new.o2_th * zeinhx;
    new.o2_tn_sek:=   new.o2_tn * zeinhx;
    new.o2_lgz_sek:=  new.o2_lgz;
    new.o2_tm_sek:=   new.o2_tm * zeinhx;
    --
    IF current_user NOT IN ('syncro', 'postgres') THEN
        PERFORM TSystem.Settings__Set('disable_handle_opreg', 'T');
        UPDATE opl SET modified_date = current_date WHERE op_ix = new.o2_ix; --letztes Änderungsdatum ASK
        PERFORM TSystem.Settings__Set('disable_handle_opreg', 'F');
    END IF;
    --
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER op2__b10_iu
    BEFORE INSERT OR UPDATE
    ON op2
    FOR EACH ROW
    EXECUTE PROCEDURE op2__b10_iu();
--

 --
 CREATE OR REPLACE FUNCTION op2__a_d() RETURNS TRIGGER AS $$
  BEGIN
    DELETE FROM op5 WHERE o5_o2_id=old.o2_id;
    RETURN old;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER op2__a_d
    AFTER DELETE
    ON op2
    FOR EACH ROW
    EXECUTE PROCEDURE op2__a_d();
 --

 --
 CREATE OR REPLACE FUNCTION op2__a_iu() RETURNS TRIGGER AS $$
  DECLARE b VARCHAR;
  BEGIN
    b:=null;
    IF (tg_op='UPDATE') THEN
        IF old.o2_txt<>new.o2_txt THEN
            b:='X';
        END IF;
        /*2012-05-18 - DS - jetzt direkt in ABK bearbeitbar, hierfür Sonderfunktion (f3) schreiben
        IF (current_user<>'syncro')AND(new.o2_aw OR old.o2_aw) THEN
            UPDATE ab2 SET a2_awtx=new.o2_awtx, a2_adkrz=new.o2_adkrz FROM abk WHERE ab_askix=new.o2_ix AND a2_ab_ix=ab_ix AND a2_n=new.o2_n AND NOT a2_ende AND (a2_awtx IS NULL OR a2_awtx=old.o2_awtx);
            UPDATE ab2 SET a2_awtx=new.o2_awtx, a2_adkrz=new.o2_adkrz FROM abk WHERE ab_askix=new.o2_ix AND a2_ab_ix=ab_ix AND a2_n=new.o2_n AND NOT a2_ende AND (a2_adkrz IS NULL OR a2_adkrz=old.o2_adkrz);
        END IF;
        */

        IF new.o2_n IS DISTINCT FROM old.o2_n THEN
            UPDATE anfart     SET aart_o2_n = new.o2_n WHERE aart_o2_id = new.o2_id;
            UPDATE bestanfpos SET bap_o2_n  = new.o2_n WHERE bap_o2_id = new.o2_id;
        END IF;
    END IF;
    IF current_user<>'syncro' THEN
        PERFORM handle_opreg(new.o2_ix, new.o2_n, 'op2', b);
    END IF;

    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER op2__a_iu
    AFTER INSERT OR UPDATE
    ON op2
    FOR EACH ROW
    EXECUTE PROCEDURE op2__a_iu();
 --

 -- Verlinkung auftragsbegleitender Artikel bei AG-Umtausch, auch op2ba__b_iu
 CREATE OR REPLACE FUNCTION op2__a_u__o2_n() RETURNS TRIGGER AS $$
  BEGIN
    UPDATE op6
       SET o6_o2_n = new.o2_n
     WHERE o6_o2_id = new.o2_id;


    UPDATE op2ba
       SET o2ba_n = new.o2_n
     WHERE o2ba_o2_id = new.o2_id;

    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER op2__a_u__o2_n
    AFTER UPDATE
    OF o2_n
    ON op2
    FOR EACH ROW
    EXECUTE PROCEDURE op2__a_u__o2_n();
 --


-- berechnet die Maschinenteil aus der Hauptzeit, der Nebenzeit und des Standardbedienerzeitanteils der Kostenstelle
CREATE OR REPLACE FUNCTION op2__b30_iu__pz_para() RETURNS TRIGGER AS $$
DECLARE
  _ks_pz_para_proz numeric;
BEGIN

  _ks_pz_para_proz := ks_pz_para_proz FROM ksv WHERE ks_abt = new.o2_ks;

  -- Bei Insert anhand von Standardbedienerzeitanteil der Kostenstelle ermitteln
  IF TG_OP = 'INSERT' THEN
    IF _ks_pz_para_proz IS NOT null AND new.o2_tm = 0 THEN
      new.o2_tm := ( new.o2_th + new.o2_tn ) * _ks_pz_para_proz / 100;
    END IF;

  -- bei Update neuen Wert basierend auf bisherigem Verhältnis berechnen
  ELSE
    -- Wenn alte Zeiten 0 waren und neue Personalzeit parallel ebenfalls 0, dann anhand von Standardbedienerzeitanteil der Kostenstelle ermitteln
    IF _ks_pz_para_proz IS NOT null AND old.o2_th + old.o2_tn + new.o2_tm = 0 THEN
      new.o2_tm := ( new.o2_th + new.o2_tn ) * _ks_pz_para_proz / 100;
    END IF;

    -- Wenn Personalzeit parallel nicht durch Anwender geändert wurde, aber Zeiten angepasst wurden, dann Personalzeit parellel anhand Verhältnis neu berechnen
    IF old.o2_tm = new.o2_tm THEN
      new.o2_tm := coalesce( old.o2_tm * ( new.o2_th + new.o2_tn ) / NULLIF( old.o2_th + old.o2_tn, 0 ), new.o2_tm );
    END IF;
  END IF;
  new.o2_tm_sek := new.o2_tm * op2__zeinh__map( new.o2_zeinh_tx );

  RETURN new;
  END $$ LANGUAGE plpgsql STRICT STABLE;
  --
  DROP TRIGGER IF EXISTS op2__b30_iu__pz_para ON op2;
  CREATE TRIGGER op2__b30_iu__pz_para
    BEFORE INSERT OR UPDATE
    OF o2_th, o2_tn, o2_ks
    ON op2
    FOR EACH ROW
    EXECUTE PROCEDURE op2__b30_iu__pz_para();
--

-- Wenn sich der Standardbedienerzeitanteil der Kostenstelle ändert,
-- dann Maschinenzeit der betroffenen ASK-Arbeitsgänge nachziehen.
-- #20121 Hauptzeit nur neu schreiben, wenn PZ parallel dem alten Verhältnis entspricht
CREATE OR REPLACE FUNCTION ksv__a90_u__pz_para() RETURNS TRIGGER AS $$
BEGIN

  UPDATE op2
     SET o2_tm = ( o2_th + o2_tn ) * new.ks_pz_para_proz / 100
   WHERE
         o2_ks     = new.ks_abt
     AND o2_tm_sek = ( o2_th_sek + o2_tn_sek ) * old.ks_pz_para_proz / 100;

  RETURN new;
  END $$ LANGUAGE plpgsql STRICT;

  CREATE TRIGGER ksv__a90_u__pz_para
    AFTER UPDATE
    OF ks_pz_para_proz
    ON ksv
    FOR EACH ROW
    WHEN (     new.ks_pz_para_proz IS DISTINCT FROM null
           AND old.ks_pz_para_proz IS DISTINCT FROM null )
    EXECUTE PROCEDURE ksv__a90_u__pz_para();
--

--Alternativkostenstellen
-- Spalten o2ks_nc sowie o2ks_prio wurden mit #14978 entfernt
  CREATE TABLE op2ksa (
  o2ks_id               SERIAL PRIMARY KEY,
  o2ks_o2_id            INTEGER NOT NULL REFERENCES op2 ON UPDATE CASCADE ON DELETE CASCADE,
  o2ks_ks               VARCHAR(9) NOT NULL REFERENCES ksv ON UPDATE CASCADE,
  o2ks_ksap             VARCHAR(50),  --Kostenstelle/Arbeitsplatz
  o2ks_ba               VARCHAR(25),
  o2ks_txt              TEXT,
  o2ks_ks_id            INTEGER, -- kostenstellenid -- https://redmine.prodat-sql.de/issues/11265
  o2ks_ks_ba_id         INTEGER  -- nummers des arbeitsplatzes -> 1-10
 );



-- alter table op2ksa add column o2ks_ks_id            INTEGER NOT NULL
-- alter table op2ksa add column o2ks_ks_ba_id         INTEGER

-- translate ks_abt to ks_id and ksap to ks_ba_id
CREATE OR REPLACE FUNCTION op2ksa__b_iu__sync_ks_id() RETURNS TRIGGER AS $$
  BEGIN

    IF new.o2ks_ks_id IS NULL THEN
      new.o2ks_ks_id := ks_id FROM ksv WHERE ks_abt = new.o2ks_ks;
    END IF;

    IF ( new.o2ks_ksap IS NOT NULL ) THEN
      new.o2ks_ks_ba_id := ksb_ks_ba_num FROM ksvba WHERE ksb_ks_abt = new.o2ks_ks AND ksb_ks_ba_babz = new.o2ks_ksap;
    ELSE
      new.o2ks_ks_ba_id := NULL;
    END IF;

    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER op2ksa__b_iu
    BEFORE INSERT OR UPDATE
    ON op2ksa
    FOR EACH ROW
    EXECUTE PROCEDURE op2ksa__b_iu__sync_ks_id();


--Subtabelle für Zuordnung stv <> op2 (#13337)
CREATE TABLE stv_op2 (
  sto2_id    SERIAL  NOT NULL PRIMARY KEY,
  sto2_st_id INTEGER NOT NULL REFERENCES stv ON UPDATE CASCADE ON DELETE CASCADE,
  sto2_o2_id INTEGER NOT NULL REFERENCES op2 ON UPDATE CASCADE ON DELETE CASCADE
);

-- Indizes
    CREATE UNIQUE INDEX xtt26484 ON stv_op2 ( sto2_st_id, sto2_o2_id );
--

 -- Trigger stellt sicher, dass auch bei manuellen Eingaben,
 -- nicht mehr als ein Arbeitsgang pro ST-N eingetragen wird
 CREATE OR REPLACE FUNCTION stv_op2__b_i() RETURNS TRIGGER AS $$
 BEGIN
    -- Löschen eines bereits vorhandenen Zuordnungseintrag
    DELETE FROM stv_op2 WHERE sto2_id =
    (
      SELECT sto2_id
      FROM stv_op2
       JOIN op2 o2_vorh ON o2_id = sto2_o2_id
       JOIN opl op_vorh ON o2_ix = op_ix
       -- gleiches Stücklistenelement
      WHERE sto2_st_id = new.sto2_st_id
        AND  EXISTS (
                      SELECT 1
                      FROM opl op_neu
                      JOIN op2 o2_neu ON op_neu.op_ix = o2_neu.o2_ix --verjoint
                                      AND op_neu.op_ix = op_vorh.op_ix -- ASK des vorhandenen Eintrags
                                      AND o2_neu.o2_id = new.sto2_o2_id -- AG der neuhinterlegt werden soll
                    )
      );
     RETURN new;

 END $$ LANGUAGE plpgsql;

 CREATE TRIGGER stv_op2__b_i
  BEFORE INSERT
  ON stv_op2
  FOR EACH ROW
  EXECUTE PROCEDURE stv_op2__b_i();
 ---
 ---  #19516
  CREATE OR REPLACE FUNCTION op2__b_iu__ks__ausw__requires__dlz() RETURNS TRIGGER AS $$
   BEGIN
     new.o2_dlz := ( SELECT coalesce( ks_dlz, 0 ) FROM ksv WHERE ks_abt = new.o2_ks );
     --
     RETURN new;
   END $$ LANGUAGE plpgsql;

  CREATE TRIGGER op2__b_iu__ks__ausw__requires__dlz
   BEFORE INSERT OR UPDATE
   OF o2_ks, o2_aw
   ON op2
   FOR EACH ROW
   WHEN ( new.o2_aw AND coalesce( new.o2_dlz, 0 ) = 0 )
   EXECUTE PROCEDURE op2__b_iu__ks__ausw__requires__dlz();
  ---
--
CREATE TABLE op2kat
  (o2k_id               SERIAL PRIMARY KEY,
   o2k_bez              VARCHAR(75) UNIQUE NOT NULL,
   o2k_grup             VARCHAR(30),
   o2k_txt              TEXT            --Standardtext für diese Bearbeitungskategorie, wird in ASK-AG vorgeschlagen wenn Kategorie gewählt wird
  );


--Auftrags/FertigungsBegleitende Artikel -ba
CREATE TABLE op2ba
  (o2ba_id              SERIAL PRIMARY KEY,
   o2ba_ix              INTEGER NOT NULL REFERENCES opl ON UPDATE CASCADE ON DELETE CASCADE, --ASK Index
   o2ba_n               SMALLINT NOT NULL, --AG-Nr
   o2ba_ak_nr           VARCHAR(40) NOT NULL,
   o2ba_noz_id          INTEGER REFERENCES normzert,  -- die qs_ident in o2ba_ak_nr
   o2ba_o2_id           INTEGER REFERENCES op2, -- direkte op2_id zB wegen umnummeriere-n, RESTRICT Anwender muss sich erst um Artikel kümmern analog op6
   o2ba_txt             TEXT,
   o2batxt_rtf          TEXT
  );

  CREATE INDEX op2ba_o2ba_o2_id ON op2ba (o2ba_o2_id) WHERE o2ba_o2_id IS NOT null;

  -- Verlinkung auftragsbegleitender Artikel bei AG-Umtausch, auch op2__a_u_o2n

  CREATE OR REPLACE FUNCTION op2ba__b_iu__o2ba_n() RETURNS TRIGGER AS $$  --INSERT OR UPDATE OF o2ba_n
   BEGIN

     new.o2ba_o2_id := (SELECT o2_id
                          FROM op2
                         WHERE o2_ix = new.o2ba_ix
                           AND o2_n = new.o2ba_n
                       );

     RETURN new;
   END $$ LANGUAGE plpgsql;


   CREATE TRIGGER op2ba__b_iu__o2ba_n
    BEFORE INSERT OR UPDATE
    OF o2ba_n
    ON op2ba
    FOR EACH ROW
    EXECUTE PROCEDURE op2ba__b_iu__o2ba_n();

--AG-ReturnParameters
CREATE TABLE op2_resultparam
  (o2r_id               SERIAL,
   o2r_o2_id            INTEGER NOT NULL REFERENCES op2 ON UPDATE CASCADE ON DELETE CASCADE,
   o2r_vname            VARCHAR(20) NOT NULL,
   o2r_vbez             VARCHAR(50),
   o2r_type             INTEGER,
   o2r_force            BOOL NOT NULL DEFAULT FALSE,
   o2r_txt              TEXT
  );

--Änderungsdienst AVOR
CREATE TABLE oplad
  (od_nr                SERIAL PRIMARY KEY,
   od_aknr              VARCHAR(40) NOT NULL REFERENCES art ON UPDATE CASCADE,
   od_aknrc             VARCHAR(40) NOT NULL REFERENCES art ON UPDATE CASCADE,
   od_edat              DATE,
   od_gdat              DATE,
   od_fdat              DATE,
   od_bes1              TEXT,
   od_bes2              TEXT,
   od_mi1               VARCHAR(40),
   od_mi2               VARCHAR(40),
   od_al                BOOL NOT NULL DEFAULT true,
   od_af                BOOL NOT NULL DEFAULT true,
   od_ak                BOOL NOT NULL DEFAULT true,
   od_at                BOOL NOT NULL DEFAULT true
  );


--TeilePrüfprotokoll / Messmittelplan - Vorgabe für ASK, Realisierung für ABK
CREATE TABLE oplpm_data (
  pm_id                SERIAL PRIMARY KEY,
  pm_op2_id            INTEGER NOT NULL REFERENCES op2 ON UPDATE CASCADE ON DELETE CASCADE,
  pm_a2_id             INTEGER, -- REFERENCES ab2 ON UPDATE CASCADE ON DELETE CASCADE; -- siehe X TableContraints.sql
  pm_pmnr              INTEGER NOT NULL, -- Prüfpositionsnummer (ehemals Prüfposition) --  xtt30072
  pm_pnkt              VARCHAR(100), -- Prüfposition, wo am Artikel wird gemessen
  pm_part              VARCHAR(40) REFERENCES art ON UPDATE CASCADE, -- Prüfmittel sind Messmittel, Lehren oder Hilfsmittel (Referenz ART, nicht ARTPR - korrigiert, LG)
  pm_nenn              VARCHAR(40), -- Nennwert = Sollwert bzw. Zielwert der zu prüfenden Eigenschaft. (für Messwerterfassung numerisch, wenn alpfanummerisch dann Boolean)
  pm_tol1              VARCHAR(20), -- Erlaubte / tolerierbare Abweichung vom Nennwert ... sind tol1 UND tol2 angegeben, muss eines >= 0 das andere <= 0 sein
  pm_tol2              VARCHAR(20), -- Erlaubte / tolerierbare Abweichung vom Nennwert
  pm_tol3              VARCHAR(20), -- Form und Lagetoleranz (Symbole oder Worte die genauer die Form und Lage der Messung oder Prüfung eingrenzen)
  pm_ma                VARCHAR(5),  -- Einheit --REFERENCES auf Einheiten??
  pm_pi                VARCHAR(50), -- Prüfschärfe: wenn Intervalltyp(pm_intv_typ)=Prozentual(10/50), dann numerisch in %, sonst freier Text.
  pm_fd                VARCHAR(1),  -- Folgedokument, wenn R dann Folgedokument=Regelkarte..
  pm_sta               VARCHAR(1),  -- Status
  pm_txt               TEXT,        -- Text zum Prüfmittel
  pm_intv_typ          INTEGER NOT NULL DEFAULT 1000, -- 10=Prozentual; 20=Erst-/Letztteil; 30=Erstteil; 40=Letzteil; 50=Prozentual und Erst-/Letztteil;
                                                      -- 1000-Freie Eingabe; .. ; Kontrolle auf Iteration in Funktion tabk.oplpm_mw__insert_from__oplpm_data
    --- #19266
  pm_einrichten        boolean,
  pm_formel            text,
  pm_hinweis           text,
  pm_hinweis_rtf       text,
  -- System (tables__generate_missing_fields)
  dbrid                VARCHAR(32) NOT NULL DEFAULT nextval('db_id_seq'), -- muss schon hier erzeugt werden aufgrund VIEW oplpm
  insert_date          DATE,
  insert_by            VARCHAR(32),
  modified_by          VARCHAR(32),
  modified_date        TIMESTAMP(0)
);

 -- Trigger VORDEFFINIERT -> entsprechend automatischem DBRID-Trigger "{table}_set_modified" für table_modified()
 CREATE TRIGGER oplpm_data_set_modified
  BEFORE INSERT OR UPDATE
  ON oplpm_data
  FOR EACH ROW
  EXECUTE PROCEDURE table_modified();
 --

 -- vormals oplpm abbilden
    CREATE OR REPLACE VIEW oplpm AS SELECT * FROM oplpm_data WHERE pm_a2_id IS NULL;
 --

 -- Indizes
    CREATE INDEX oplpm_data_pm_op2_id ON oplpm_data (pm_op2_id);
    CREATE INDEX oplpm_data_pm_part ON oplpm_data (pm_part);
 --

 --
 CREATE OR REPLACE FUNCTION oplpm_data__a_iud() RETURNS TRIGGER AS $$
  DECLARE id INTEGER;
          ix INTEGER;
        a2id INTEGER;
  BEGIN
    IF tg_op='DELETE' THEN
        id:=old.pm_op2_id;
       a2id:= old.pm_a2_id;
    ELSE
        id:=new.pm_op2_id;
      a2id:=new.pm_a2_id;
    END IF;
    --
    SELECT o2_ix INTO ix FROM op2 WHERE o2_id=id;

    --Änderungsdatum Messplan - für Stammkartenprüfmerkmale (Vorlagen) geändert PHKO #9035
    IF a2id IS NULL THEN -- Sonst wird eine Änderung beim Anlegen einer ABK eingetragen #9035
     UPDATE opl SET
       op_mp_insert_date=COALESCE(op_mp_insert_date, current_date),
       op_mp_insert_by=COALESCE(op_mp_insert_by, current_user),
       op_mp_modified_date=current_date,
       op_mp_modified_by=current_user
     WHERE op_ix=ix;
    END IF;
    --
    IF tg_op='DELETE' THEN
        RETURN old;
    ELSE
        RETURN new;
    END IF;

  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER oplpm_data__a_iud
    AFTER INSERT OR UPDATE OR DELETE
    ON oplpm_data
    FOR EACH ROW
    EXECUTE PROCEDURE oplpm_data__a_iud();
 --

 -- Triggerfunktion oplpm_data__a_iu_pruefmerkmale
 CREATE OR REPLACE FUNCTION oplpm_data__a_i_pruefmerkmale() RETURNS TRIGGER AS $$
  BEGIN
    PERFORM TABK.oplpm_mw__insert_from__oplpm_data( new.pm_id );
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER oplpm_data__a_i_pruefmerkmale
    AFTER INSERT
    ON oplpm_data
    FOR EACH ROW
    WHEN ( new.pm_a2_id IS NOT null )
    EXECUTE PROCEDURE oplpm_data__a_i_pruefmerkmale();
 --

 --
CREATE OR REPLACE FUNCTION oplpm_data__pm_part__b_ud() RETURNS TRIGGER AS $$
  DECLARE
    _messwerte_vorhanden boolean;
    _a2_ab_ix varchar;
    _a2_n integer;
  BEGIN
    -- verhindert Modifikationen und Löschungen der Prüfprotokolle bei bereits vorgenommenen Messungen

    _messwerte_vorhanden := EXISTS(
      SELECT 1 FROM oplpm_mw WHERE mw_pm_id = old.pm_id AND mw_messwert IS NOT null
    );

    -- Formatierung der Fehlermeldungen: <Meldung xtt>
    IF tg_op = 'DELETE' THEN
        IF _messwerte_vorhanden THEN
          SELECT a2_ab_ix, a2_n INTO _a2_ab_ix, _a2_n
            FROM oplpm_data
            LEFT JOIN ab2 ON a2_id = old.pm_a2_id;
          RAISE EXCEPTION
            'Prüfprotokoll mit Messwerten kann nicht gelöscht werden xtt28784 % %/%/%',
              'pm_pmnr/ab_ix/a2_n:', old.pm_pmnr, _a2_ab_ix, _a2_n;
        END IF;
        RETURN old;
    ELSE
        IF _messwerte_vorhanden AND old.pm_part IS DISTINCT FROM new.pm_part THEN
          SELECT a2_ab_ix, a2_n INTO _a2_ab_ix, _a2_n
            FROM oplpm_data
            LEFT JOIN ab2 ON a2_id = new.pm_a2_id;
          RAISE EXCEPTION
            'Prüfprotokoll mit Messwerten kann nicht modifiziert werden xtt28783 % %/%/%',
              'pm_pmnr/ab_ix/a2_n:', new.pm_pmnr, _a2_ab_ix, _a2_n;
        END IF;
        RETURN new;
    END IF;

   END $$ LANGUAGE plpgsql;

  CREATE TRIGGER oplpm_data__pm_part__b_ud
    BEFORE UPDATE OR DELETE
    ON oplpm_data
    FOR EACH ROW
    EXECUTE PROCEDURE oplpm_data__pm_part__b_ud();
 --

--Prüfprotokoll / Messwerte
CREATE TABLE oplpm_mw
  (mw_id               SERIAL PRIMARY KEY,
   mw_pm_id            INTEGER NOT NULL REFERENCES oplpm_data ON DELETE CASCADE,
   mw_messwert         VARCHAR(50),                     --    Messwert - Eingabe
   mw_pruefer          VARCHAR(10),                     --    REFERENCES llv ON UPDATE CASCADE ON DELETE SET NULL,
   mw_pruefzeit        TIMESTAMP(0),                    --    Messzeitpunkt
   mw_werkst_temper    NUMERIC(6,3),                    --    Werkstücktemperatur °C
   mw_messmasch_temper NUMERIC(6,3),                    --    Temperatur Messmaschine °C
   mw_lfdnr            INTEGER,                         --    ?
   mw_pr_pmnr          VARCHAR(50),                     --    Prüfmittelnummer
   mw_definitiv        boolean NOT null DEFAULT false   --    Ist dieser Messung abgeschlossen?
  );


   CREATE OR REPLACE FUNCTION oplpm_mw__b_u__mw_messwert() RETURNS TRIGGER AS $$
   -- Wenn nicht in Toleranz und keine Begründung, dann Fehler;
   -- und Feld: mw_pr_pmnr muss gefüllt sein
    DECLARE

     _prufmittelzwang boolean;
     _pruefmittel_angegeben boolean;
    BEGIN

     IF new.mw_messwert IS null AND old.mw_messwert IS NOT null THEN
        RAISE EXCEPTION 'deleting mw_messwert not allowed xtt28851';  -- 'Messwerte können nicht gelöscht werden.'
     END IF;

     IF new.mw_messwert IS null AND new.mw_definitiv THEN
        -- Messung ohne Messwert kann nicht abgeschlossen werden.
        RAISE EXCEPTION 'xtt28833';
     END IF;

     -- Ist die dynamische Einstellung nicht vorhanden, dann wird sie als "false" interpretiert
     _prufmittelzwang := tsystem.settings__getbool( 'OPLPM_MW__PRUEFMITTELZWANG' );
     _pruefmittel_angegeben := nullif( trim( new.mw_pr_pmnr ), '') IS NOT null;
     IF new.mw_pr_pmnr is null AND _prufmittelzwang THEN
        RAISE EXCEPTION 'xtt29370';  -- 'Prüfmittel ist nicht vorhanden.'
     END IF;

     -- Prüfer wird nur geändert, wenn noch kein Prüfer gesetz war
     --   oder sich der Messwert geändert hat
     IF old.mw_messwert IS null OR old.mw_messwert <> new.mw_messwert OR old.mw_pruefer IS null THEN
       new.mw_pruefer := current_user;
     END IF;

     IF NOT _pruefmittel_angegeben AND _prufmittelzwang THEN
        IF new.mw_messwert IS NOT NULL THEN
           RAISE EXCEPTION 'xtt30066'; --Prüfmittel-ID ist nicht gefüllt!
        END IF;
     ELSE
        IF
         NOT EXISTS(SELECT true
                     FROM artpr
                     JOIN oplpm_data ON new.mw_pm_id = oplpm_data.pm_id
                    WHERE
                            ( artpr.pr_aknr = oplpm_data.pm_part)
                        AND ( artpr.pr_pmnr = new.mw_pr_pmnr )
                   )
         AND _pruefmittel_angegeben
        THEN
         RAISE EXCEPTION 'xtt30067'; --Prüfmittel-ID existiert nicht!
        END IF;
     END IF;

     IF
             NOT tartikel.artpr__pruefmittel__einsatzbereit__is((
                 SELECT pr_id FROM artpr
                 JOIN oplpm_data ON artpr.pr_pmnr = new.mw_pr_pmnr AND artpr.pr_aknr = pm_part
                 WHERE pm_id = new.mw_pm_id
                 LIMIT 1
             ))
         AND new.mw_messwert IS NOT null
         AND _pruefmittel_angegeben
     THEN
         RAISE EXCEPTION 'xtt28828'; --Prüfmittel nicht einsatzbereit
     END IF;

     IF
             new.mw_definitiv
         AND (
                 old.mw_messwert IS DISTINCT FROM new.mw_messwert
              OR old.mw_pr_pmnr  IS DISTINCT FROM new.mw_pr_pmnr
         )
     THEN
         RAISE EXCEPTION 'xtt28853'; -- Messung bereits abgeschlossen
     END IF;

     IF tsystem.settings__getbool( 'MESSWERTE_AUTO_DEFINITIV' ) AND new.mw_messwert IS not null THEN
         new.mw_definitiv := true;
     END IF;

     IF AsNumeric(new.mw_messwert) IS NOT NULL THEN
       -- warum diese Zeile? Strings mit Komma (z.B.: "1,2", "-2.3") werden zu Numerics (1.2, -2.3) gewandelt
      new.mw_messwert := AsNumeric(new.mw_messwert); -- #13633 NEG kein ABS mehr - es gibt negative Messwerte
     END IF;

     IF
         new.mw_messwert IS NOT null
         OR ( new.mw_lfdnr > ( SELECT min ( mw_lfdnr ) FROM oplpm_mw WHERE mw_pm_id = new.mw_pm_id )) THEN
       IF ( abs( TQS.oplpm_mw__get_abweichung( new )) > 100) AND ( not get_record_has_note( new.dbrid )) THEN
         RAISE EXCEPTION 'xtt30068'; --Messwert ist außerhalb der Toleranz, Notiz mit Begründung ist Pflicht!
       END IF;
     END IF;

     -- Zeitpunkt der Messung festhalten
     IF old.mw_messwert IS DISTINCT FROM new.mw_messwert THEN
       new.mw_pruefzeit := now();
     END IF;

     RETURN new;
    END $$ language plpgsql;

   CREATE TRIGGER oplpm_mw__b_u__mw_messwert
    BEFORE UPDATE OF mw_messwert, mw_pr_pmnr, mw_definitiv
    ON oplpm_mw
    FOR EACH ROW
    EXECUTE PROCEDURE oplpm_mw__b_u__mw_messwert();


   CREATE OR REPLACE FUNCTION public.oplpm_mw__b_d() RETURNS TRIGGER AS $$
   -- Abgeschlossene Messungen können nicht gelöscht werden.
    BEGIN

        RAISE EXCEPTION 'xtt28832';  -- Eine abgeschlossene Messung kann nicht gelöscht werden.

    END$$ language plpgsql;

   CREATE TRIGGER oplpm_mw__b_d
    BEFORE DELETE
    ON oplpm_mw
    FOR EACH ROW
    WHEN ( old.mw_definitiv )
    EXECUTE PROCEDURE oplpm_mw__b_d();


-- Tabelle für die Ermittlung der Prüfmenge bei gegebener Prüfhäufigkeit
CREATE TABLE oplpm_data_pruefmenge (

    -- ID, wird nicht aus einer Sequenz geholt
    opmpmg_id        integer NOT null PRIMARY KEY,

    -- Bezeichung
    opmpmg_bez       varchar(60) NOT null,

    -- ID der Beszeichnung in text0
    opmpmg_bez_xtt   integer,

    -- wird das Erstteil geprüft?
    opmpmg_erstteil  boolean NOT null,

    -- wird das Letztteil geprüft?
    opmpmg_letztteil boolean NOT null,

    -- wird ein prozentualer Anteil der Fertigungsmenge geprüft?
    opmpmg_prozent   boolean NOT null
);



--- #12969  KB.Proj.MP.EDI
CREATE SEQUENCE tqs_messmaschinenimport__mmi_id__seq START WITH 1;
CREATE SCHEMA IF NOT EXISTS tqs;
CREATE TABLE tqs.MessmaschinenImport(
    mmi_id             SERIAL PRIMARY KEY,
    mmi_import_nr    INTEGER,                -- Import-Nr. pro Datei gleich
    mmi_date           DATE,               -- Datum der Messung laut Messmaschinendaten
    mmi_time          TIME,                  -- Zeitpunkt der Messung laut Messmaschinendaten
    mmi_auftg      VARCHAR(20),          -- Auftragsnummer / ABK
    mmi_device      VARCHAR(3) NOT NULL,  -- Geräte-ID lt. EDI
    mmi_row          INTEGER NOT NULL,       -- EDI-Zeilennummer (0 = Caption)
    mmi_info      JSONB,               -- Infodaten im JSON-B-Format
    mmi_data      JSONB,               -- Messdaten im JSON-B-Format
    mmi_status      VARCHAR(1),            -- Verarbeitungsstatus
    mmi_pm_id      INTEGER                -- oplpm_data.pm_id
);

-- Ermittelt für ein Prüfmerkmal (oplpm_data mit ABK-Bezug) ob die bisherigen Messungen innerhalb der Toleranz waren.
CREATE OR REPLACE FUNCTION tqs.oplpm_wm__check__pm(
    IN  _pm oplpm_data,
    OUT anzMessungen integer,
    OUT anzMesswerte integer,
    OUT anzFailed integer,
    OUT pmPassed boolean
  ) RETURNS RECORD AS $$
  DECLARE
    _r RECORD;
  BEGIN
    anzMessungen := 0;
    anzMesswerte := 0;
    anzFailed    := 0;
    pmPassed     := false;

    -- Anzahl der noch offenen Messungen
    anzMessungen := count(*) FROM oplpm_mw WHERE mw_pm_id = _pm.pm_id;

    IF anzMessungen = 0 THEN
      RETURN;
    END IF;

    -- Über alle Einträge in der Messwerttabelle loopen
    FOR _r IN ( SELECT mw_messwert FROM oplpm_mw WHERE mw_pm_id = _pm.pm_id ) LOOP

      IF _r.mw_messwert IS NOT null THEN
        -- Abweichung nach oben oder unten mehr als 100% der Toleranz ... das ist also nicht mehr im Rahmen ...
        IF abs( TQS.oplpm_mw__get_abweichung( _r.mw_messwert, _pm.pm_nenn, _pm.pm_tol1, _pm.pm_tol2 )) > 100 THEN
          anzFailed := anzFailed + 1;
        END IF;
        anzMesswerte := anzMesswerte + 1;
      END IF;
    END LOOP;

    IF ( anzMessungen = anzMesswerte ) AND ( anzFailed = 0 ) THEN
      pmPassed := true;
    END IF;

    RETURN;
  END $$ LANGUAGE plpgsql STABLE;
--

--  Prozentuale Abweichung des Messwertes vom Zielwert. NULL - Wenn keine sinnvollen Zahlen angegeben.
CREATE OR REPLACE FUNCTION TQS.oplpm_mw__get_abweichung(mw oplpm_mw) RETURNS numeric AS $$
 DECLARE pm oplpm_data;
 BEGIN
   -- IN Nennwert: Überschriebener Nennwert aus Prüfmerkmal, z.Bsp. korrigiert mit Abweichung aus Artikelinfo.
   pm := oplpm_data FROM oplpm_data WHERE pm_id = mw.mw_pm_id;
   RETURN TQS.oplpm_mw__get_abweichung(mw.mw_messwert,
                                       pm.pm_nenn,
                                       pm.pm_tol1,
                                       pm.pm_tol2);
 END $$ LANGUAGE plpgsql;
--

--
CREATE OR REPLACE FUNCTION TQS.oplpm_mw__get_abweichung(
      _messwert     varchar,
      _nennwert     varchar,
      _toleranz_1   varchar,
      _toleranz_2   varchar
  ) RETURNS numeric AS $$
  DECLARE
      -- angestrebten Wert eines quantitativen Merkmales eines Systems
      _nennwert_numerisch   numeric;

      -- numerisches Ergebnis der Messung
      _messwert_numerisch   numeric;

      -- Toleranz 1 (pos. oder neg.) obere oder untere Grenzabweichung vom Sollmaß
      _toleranz_1_numerisch numeric;

      -- Toleranz 2 (pos. oder neg.) oberes oder unteres Grenzabweichung vom Sollmaß
        -- Toleranzen können beide positiv oder beide negativ sein.
        -- Das Nennmaß ist dann außerhalb des Toleranzfeldes
      _toleranz_2_numerisch numeric;

      -- Die Grenzmaße sind das Höchst- bzw. Größtmaß und das Mindest- bzw. Kleinstmaß,
        -- zwischen denen das Istmaß eines Werkstückes liegen muss.
      _mindestmass          numeric;
      _hoechstmass          numeric;

      -- "Sollmaß" (Nennmaß + Toleranz 1 + Nennmaß + Toleranz 2 ) / 2
        -- der "Nullpunkt", da wo die relative Abweichung vom am geringsten ist.
      _sollmass             numeric;

      -- "Idealwert" - Mindestmaß (oder Höchstmaß), daraus ergibt sich der Wert für die
      -- maximal zulaessige Abweichung = 1 oder 100%.
      _abweichung_max       numeric;

      -- Messwert - "Idealwert"
        -- die Reihenfolge von Minuend und Subtrahend ist wichtig, damit das Vorzeichen richtig ist
        -- und Messwerte die kleiner als der "Idealwert" sind mit einem Minus angegeben.
      _abweichung_messwert  numeric;


      -- Ausgabe- und Fehler-Konstanten:
      _messwert_null                CONSTANT numeric := 110001;
      _messwert_false               CONSTANT numeric := 110002;
      _abweichung_unendlich         CONSTANT numeric := 110003;
      _error_messwert_not_numeric   CONSTANT numeric := 220001;
      _error_NaN                    CONSTANT numeric := 220002;

  BEGIN
      -- Prozentuale Abweichung vom Messwert zum Nullpunkt innerhalb des Toleranzfeldes
      -- Messwerte können entweder numerisch oder boolsch sein:
      -- numerischer Nennwert -> numerische Mess- und Toleranzwerte erwartet
      -- nicht-numerischer Nennwert -> boolscher Messwert erwartet, Toleranzwerte irrelevant

      IF _messwert IS null THEN
          RETURN _messwert_null;
      END IF;

      -- wenn Nennwert numerisch, dann muss das auch für den Messwert gelten,
      -- ansonsten ist die Abweichung maximal
      _messwert_numerisch := AsNumeric( _messwert );
      _nennwert_numerisch := AsNumeric( _nennwert );

      -- Prüfung boolscher Messwerte, siehe #15921
        -- String-Übereinstimmungen von Mess- und Nennwert spielen hier keine Rolle
      IF _nennwert_numerisch IS null THEN

          IF lower( _messwert ) = 'true' THEN
              RETURN 0;
          ELSE
              RETURN _messwert_false;
          END IF;

      END IF;

      -- Fehler-Wert: Kein numerischer Messwert
      IF _messwert_numerisch IS null THEN
          RETURN _error_messwert_not_numeric;
      END IF;


      _toleranz_1_numerisch  := AsNumeric( _toleranz_1, true ); -- Option true: NullToZero
      _toleranz_2_numerisch  := AsNumeric( _toleranz_2, true );


      _sollmass :=
          ( (_nennwert_numerisch + _toleranz_1_numerisch) + (_nennwert_numerisch + _toleranz_2_numerisch) ) / 2
      ;


      -- Ausgabe-Wert: unendliche Abweichung
        -- beide Toleranzen sind mit 0 angegeben und der Messwert entspricht nicht dem Nennwert.
      IF
              _toleranz_1_numerisch = 0
          AND _toleranz_2_numerisch = 0
          AND _messwert_numerisch <> _nennwert_numerisch

      THEN
          RETURN _abweichung_unendlich;
      END IF;


      -- wenn Toleranz 1 kleiner Toleranz 2, dann werden Mindest- und Höchstmaß wie folgt bestimmt:
      IF _toleranz_1_numerisch < _toleranz_2_numerisch THEN
          _mindestmass := _nennwert_numerisch + _toleranz_1_numerisch;
          _hoechstmass := _nennwert_numerisch + _toleranz_2_numerisch;
      ELSE
          _mindestmass := _nennwert_numerisch + _toleranz_2_numerisch;
          _hoechstmass := _nennwert_numerisch + _toleranz_1_numerisch;
      END IF;


      -- Es ist egal, ob Höchstmass oder Mindestmaß den gleichen Abstand zum "Idealwert" haben.
      _abweichung_max := _sollmass - _mindestmass;

      -- für Messwerte über dem Sollmaß positiv und Messwerte unter dem Sollmaß negativ:
      _abweichung_messwert := _messwert_numerisch -_sollmass;


      -- Fehler: NaN bei Berechnung
      IF _abweichung_max = 'NaN' OR _abweichung_messwert = 'NaN' THEN
          RETURN _error_NaN;
      END IF;



      -- prozentuelle Abweichung ausgeben
      RETURN _abweichung_messwert / Do1If0( _abweichung_max ) * 100;

  END $$ LANGUAGE plpgsql STABLE;
--

--
    CREATE OR REPLACE FUNCTION TQS.oplpm_mw__get_datatype(IN mw VARCHAR) RETURNS VARCHAR(15) AS
    $$
    BEGIN
      IF IsNumeric(COALESCE(AsNumeric(mw)::VARCHAR, 'FAIL')) THEN -- wenn AsNumeric Null wiedergibt, dann ist der Wert nicht nummerisch!
        RETURN 'ptNUMERIC';
      ELSE
        RETURN 'ptBOOLEAN';
      END IF;
    END $$ LANGUAGE plpgsql;

/*  #12905 TQS.value__get__numeric_value_with_decimalplaces
    #21625 Redesign

    Der Eingangsstring wird in eine Zahl umgewandelt und im Erfolgsfall neu formatiert zurückgegeben.
    Tausendertrenner werden gelöscht, es wird der übergebene Dezimaltrenner verwendet. Die Mindestzahl an Nachkommastellen
    wird nur ausgeschöpft, wenn es dazu keine nachgestellten Nullen braucht. Auf Wunsch wird noch ein führendes Pluszeichen
    ergänzt.
    
    Folgende Annahmen fließen in die Funktion ein:
    - Zulässige Tausendertrenner sind Leerzeichen, Apostroph, Punkt und Komma.
    - Zulässige Dezimaltrenner sind Punkt und Komma.
    - Tausendertrenner treten immer mit Dezimaltrenner auf. Ohne diese Annahme lässt sich schwer sagen, ob 1.500 drei Halbe oder Eintausendfünfhundert bedeutet.
    - Der ganzzahlige Anteil der übergebenen Zahl geht nicht in die Billionen.
*/
    
CREATE OR REPLACE FUNCTION TQS.value__get__numeric_value_with_decimalplaces(
    inout_txt         IN OUT varchar,               -- Ein- und Ausgabetext
    in_nk_stellen     IN integer,                   -- Mindestanzahl der Nachkommastellen bei der Ausgabe (ohne nachgestellte Nullen)
    in_show_plus      IN boolean DEFAULT true,      -- Pluszeichen in der Ausgabe anzeigen?
    in_decimal_split  IN varchar DEFAULT ',',       -- Dezimaltrennzeichen bei der Ausgabe
    out_is_numeric    OUT boolean,                  -- Ausgabe: Eingabewert numerisch?
    out_abs           OUT varchar                   -- Ausgabe: Absolutwert
) AS $$
DECLARE
    _txt_dec          varchar;                      -- Dezimalteil
    _txt_zeros        varchar;                      -- Teil der nachgestellten Nullen im Dezimalteil
    _format           varchar := 'FM99999999990';   -- Formatstring für die Typenwandlung
    _temp             varchar;                      -- temporärer String
    _temp_num         numeric;                      -- temporärer numerischer Wert
    _num_nachkomma    integer;                      -- Anzahl der ausgegebenen Nachkommastellen
BEGIN
     -- Standard: Eingabestring ist nicht numerisch
    out_is_numeric := false;
    out_abs := null;

    -- Originalstring sichern
    _temp := trim( inout_txt );
    
    -- Prüfung, ob eine Zahl übergeben wurde, bestehend aus:
    ---- [+-]?        - einem optionalem Vorzeichen
    ---- \d+          - mindestens einer Ziffer
    ---- [ ',.]d{3})* - eventuell gefolgt von einem oder mehren Blöcken bestehensd aus einem Tausendertrenner (Punkt, Komma, Leerzeichen oder Apostroph) und drei Ziffern
    ---- ([,.]\d+)?   - am Ende ggf. eine Dezimaltrenner (Punkt oder Komma) und einige Ziffern
    IF _temp !~ E'^([+-]?\\d+([ '',.]\\d{3})*([,.]\\d*)?)$' THEN 
      RETURN;
    END IF;
    
    -- speichert den Dezimalteil inkl. Komma
    _txt_dec := coalesce( substring( _temp FROM E'[.,]\\d*$' ), '' ); 
    
    -- speichert die nachgestellten Nullen des Dezimalteils
    _txt_zeros := coalesce( substring( _txt_dec FROM E'0*$' ), '' ); 
    
    -- baut den Originalstring wieder zusammen mit einem X anstelle des Kommas
    _temp := substring( _temp, 1, length( _temp ) - length( _txt_dec )) || 'X' || substring( _txt_dec, 2, 10000 );
    raise notice '%', _temp;
    
    -- alle Tausendertrenner löschen
    _temp := replace( _temp, ' ', '' );
    _temp := replace( _temp, '''', '' );
    _temp := replace( _temp, ',', '' );
    _temp := replace( _temp, '.', '' );
    
    -- Komma wieder herstellen
    _temp := replace( _temp, 'X', '.' );
    
    -- Umwandlung in eine Zahl
    _temp_num := asNumeric( _temp );
    IF _temp_num IS null THEN 
      RETURN;
    END IF;
    
    -- Ggf. Nachkommastellen im Ausgabeformat ergänzen
    _num_nachkomma := max( in_nk_stellen, length( _txt_dec ) - 1 - length( _txt_zeros ));
    IF _num_nachkomma > 0 THEN
      _format := _format || 'D' || repeat( '0', _num_nachkomma );
    END IF; 
    
    -- Zurückwandeln in einen String
    _temp := to_char( _temp_num, _format );  
    
    -- Korrektes Kommazeichen setzen
    _temp := replace( _temp, '.', in_decimal_split );
    
    -- Ausgabewerte setzen
    inout_txt := _temp;
    out_abs := replace( inout_txt, '-', '' );
    out_is_numeric := true;
    
    -- Ggf. Pluszeichen ergänzen
    IF _temp_num > 0 AND in_show_plus THEN
      inout_txt := '+' || inout_txt;
    END IF;
    
END $$ LANGUAGE plpgsql;
--

-- #12803 TQS.oplpm_data__get__pruefpunkt_bezeichnung_kurz
CREATE OR REPLACE FUNCTION TQS.oplpm_data__get__pruefpunkt_bezeichnung_kurz(in_pmid       IN INTEGER,
                                                                            in_nk_stellen IN INTEGER DEFAULT 0,
                                                                            in_decimal_split IN VARCHAR DEFAULT ',') RETURNS VARCHAR AS $$
DECLARE
  _pmpnkt            VARCHAR(100);
  _pmnenn            VARCHAR(40);
  _pmma              VARCHAR(40);
  _is_fl             BOOLEAN;
BEGIN
  -- Ermitteln der relevanten Daten aus der Quelltabelle
  SELECT COALESCE(TRIM(pm_pnkt) ||' ', ''),
         COALESCE(TRIM(pm_nenn), ''),
         COALESCE(TRIM(pm_ma), ''),
         TRIM(pm_tol3) IS NOT NULL
  INTO _pmpnkt, _pmnenn, _pmma, _is_fl
  FROM oplpm_data
  WHERE pm_id = in_pmid;

  -- Wenn Nennmaß vorhanden, dann prüfen ob ein numerischer Wert vorliegt und diesen auf angegebene NK-Stellenzahl anpassen, wenn notwendig/möglich
  IF _pmnenn <> '' THEN
    SELECT inout_txt
    INTO _pmnenn
    FROM TQS.value__get__numeric_value_with_decimalplaces(inout_txt        => _pmnenn,
                                                          in_nk_stellen    => in_nk_stellen,
                                                          in_decimal_split => in_decimal_split,
                                                          in_show_plus     => false);
  END IF;

  -- zusammengefügten String zurückgeben
  IF _is_fl THEN
    RETURN TRIM(CONCAT(_pmpnkt, lang_text(29590)));
  ELSE
    RETURN  TRIM(CONCAT(_pmpnkt, _pmnenn, _pmma));
  END IF;
END $$ LANGUAGE plpgsql;

-- #12806 TQS.oplpm_data__get__pruefpunkt_bezeichnung_komplett
CREATE OR REPLACE FUNCTION TQS.oplpm_data__get__pruefpunkt_bezeichnung_komplett(in_pmid       IN INTEGER,
                                                                                in_nk_stellen IN INTEGER DEFAULT 0,
                                                                                in_decimal_split IN VARCHAR DEFAULT ',') RETURNS VARCHAR AS $$
DECLARE
  _pruefpos_name     VARCHAR(100);
  _tol1              VARCHAR(40);
  _tol2              VARCHAR(40);
  _is_tol1_numeric   BOOLEAN := FALSE;
  _is_tol2_numeric   BOOLEAN := FALSE;
  _tol1_abs          VARCHAR(40);
  _tol2_abs          VARCHAR(40);
  _pmma              VARCHAR(40);
BEGIN

  -- Kurzbezeichnung aus Prüfpunkt, Nennmaß und Maßeinheit holen
  _pruefpos_name :=  TRIM(TQS.oplpm_data__get__pruefpunkt_bezeichnung_kurz (in_pmid          => in_pmid,
                                                                            in_nk_stellen    => in_nk_stellen,
                                                                            in_decimal_split => in_decimal_split));

   -- Abfrage der Quelldaten zur ID, ob überhaupt Grenzwerte angegeben wurden
  SELECT pm_tol1, pm_tol2, CASE WHEN pm_tol3 IS NOT NULL THEN pm_ma ELSE NULL END
  INTO _tol1, _tol2, _pmma
  FROM oplpm_data
  WHERE pm_id = in_pmid;

  -- denn wenn beide Werte null -> Kurzbezeichnung zurückgeben
  IF _tol1 IS NULL AND _tol2 IS NULL THEN
    RETURN _pruefpos_name;
  END IF;

  -- jetzt numerische Werte ermitteln, allerdings nur wenn gegegeben
  IF _tol1 IS NOT null THEN
    SELECT *
    INTO _tol1 , _is_tol1_numeric, _tol1_abs
    FROM TQS.value__get__numeric_value_with_decimalplaces(inout_txt        => _tol1,
                                                          in_nk_stellen    => in_nk_stellen,
                                                          in_decimal_split => in_decimal_split);
  END IF;

  -- jetzt numerische Werte ermitteln, allerdings nur wenn gegegeben
  IF _tol2 IS NOT null THEN
    SELECT *
    INTO _tol2 , _is_tol2_numeric, _tol2_abs
    FROM  TQS.value__get__numeric_value_with_decimalplaces (inout_txt        => _tol2,
                                                            in_nk_stellen    => in_nk_stellen,
                                                            in_decimal_split => in_decimal_split);
  END IF;

  -- numerisch: wenn Betrag der beiden Werte gleich,die Werte jedoch ungleich sind, dann mit ± ausgeben
  IF _is_tol1_numeric AND _is_tol2_numeric AND _tol1_abs = _tol2_abs AND _tol1 != _tol2 THEN

     RETURN CONCAT(_pruefPos_name, ' ±', _tol1_abs, _pmma);
  END IF;

  IF COALESCE(_tol1, '') != COALESCE(_tol2, '') THEN
    -- unterschiedlich -> beide anfügen
    RETURN CONCAT(_pruefPos_name, COALESCE(' ' || _tol1, '') , COALESCE(' ' || _tol2, ''), _pmma);
  ELSE
    -- wenn beide gleich sind, dann nur einen anfügen
    RETURN CONCAT(_pruefPos_name, ' ' , _tol1, _pmma);
  END IF;

END $$ LANGUAGE plpgsql;

-- #13079 TQS.oplpm_data__get__pruefpunkt_bezeichnung_technisch: Im Vergleich zur Komplett-Funktion keine Maßeinheit und kein Prüfpunkt
CREATE OR REPLACE FUNCTION TQS.oplpm_data__get__pruefpunkt_bezeichnung_technisch(in_pmid       IN INTEGER,
                                                                                 in_nk_stellen IN INTEGER DEFAULT 0,
                                                                                 in_decimal_split IN VARCHAR DEFAULT ',') RETURNS VARCHAR AS $$

DECLARE
  _pmnenn            VARCHAR(40);
  _tol1              VARCHAR(40);
  _tol2              VARCHAR(40);
  _is_tol1_numeric   BOOLEAN := FALSE;
  _is_tol2_numeric   BOOLEAN := FALSE;
  _tol1_abs          VARCHAR(40);
  _tol2_abs          VARCHAR(40);
BEGIN

  -- Nennmaß - muss auch rein  numerisch sein
  SELECT COALESCE(TRIM(pm_tol3), COALESCE(TRIM(pm_nenn), ''))
  INTO _pmnenn
  FROM oplpm_data
  WHERE pm_id = in_pmid;

  IF _pmnenn <> '' THEN
    SELECT inout_txt
    INTO _pmnenn
    FROM TQS.value__get__numeric_value_with_decimalplaces(inout_txt        => _pmnenn,
                                                          in_nk_stellen    => in_nk_stellen,
                                                          in_decimal_split => in_decimal_split,
                                                          in_show_plus     => false);
  END IF;

  -- Abfrage der Quelldaten zur ID, ob überhaupt Grenzwerte angegeben wurden
  SELECT TRIM(pm_tol1), trim(pm_tol2)
  INTO _tol1, _tol2
  FROM oplpm_data
  WHERE pm_id = in_pmid;

  -- denn wenn beide Werte null -> Kurzbezeichnung zurückgeben
  IF _tol1 IS NULL AND _tol2 IS NULL THEN
    RETURN _pmnenn;
  END IF;

  -- jetzt numerische Werte ermitteln, allerdings nur wenn gegegeben
  IF _tol1 IS NOT null THEN
    SELECT *
    INTO _tol1 , _is_tol1_numeric, _tol1_abs
    FROM TQS.value__get__numeric_value_with_decimalplaces(inout_txt        => _tol1,
                                                          in_nk_stellen    => in_nk_stellen,
                                                          in_decimal_split => in_decimal_split);
  END IF;

  -- jetzt numerische Werte ermitteln, allerdings nur wenn gegegeben
  IF _tol2 IS NOT null THEN
    SELECT *
    INTO _tol2 , _is_tol2_numeric, _tol2_abs
    FROM  TQS.value__get__numeric_value_with_decimalplaces (inout_txt        => _tol2,
                                                            in_nk_stellen    => in_nk_stellen,
                                                            in_decimal_split => in_decimal_split);
  END IF;

  -- numerisch: wenn Betrag der beiden Werte gleich,die Werte jedoch ungleich sind, dann mit ± ausgeben
  IF _is_tol1_numeric AND _is_tol2_numeric AND _tol1_abs = _tol2_abs AND _tol1 != _tol2 THEN

     RETURN CONCAT(_pmnenn, ' ±'  , _tol1_abs);
  END IF;

  IF COALESCE(_tol1, '') != COALESCE(_tol2, '') THEN
    -- unterschiedlich -> beide anfügen
    RETURN CONCAT(_pmnenn, COALESCE(' '|| _tol1, '') , COALESCE(' ' || _tol2, ''));
  ELSE
    -- wenn beide gleich sind, dann nur einen anfügen
    RETURN CONCAT(_pmnenn, ' ', _tol1);
  END IF;

END $$ LANGUAGE plpgsql;


 /*Sondereinzelkosten*/

 CREATE TABLE op3
  (o3_id                SERIAL PRIMARY KEY,
   o3_pos               INTEGER,
   o3_ix                INTEGER NOT NULL REFERENCES opl ON UPDATE CASCADE ON DELETE CASCADE,
   o3_preis             NUMERIC NOT NULL,
   o3_txt               VARCHAR(75) NOT NULL
  );

 /*Fertigungszeitberechnung*/

 CREATE TABLE ferber
  (fb_name              VARCHAR(20) PRIMARY KEY,
   fb_bez               TEXT,
   fb_rech              TEXT/*,
   fb_fert              TEXT,
   fb_neben             TEXT*/
  );

 CREATE TABLE ferber_params
  (fbrp_id              SERIAL PRIMARY KEY,
   fbrp_pos             INTEGER,
   fbrp_ferber          VARCHAR(20) REFERENCES ferber ON UPDATE CASCADE ON DELETE CASCADE,
   fbrp_descr           VARCHAR(80) NOT NULL,
   fbrp_name            VARCHAR(10) NOT NULL,
   fbrp_default         NUMERIC,
   fbrp_formula         VARCHAR(100)
  );


 /*Arbeitsschritte*/
 CREATE TABLE op5
  (o5_id                SERIAL PRIMARY KEY,
   o5_o2_id             INTEGER NOT NULL, --derzeit kein references, da die oberfläche (noch) nicht im sql cached updates arbeitet
   o5_asnr              INTEGER,
   o5_txt               TEXT,
   o5_wz_aknr           VARCHAR(40) REFERENCES art ON UPDATE CASCADE,--Werkzeug
   o5_wz_kf             NUMERIC DEFAULT 1,--korrekturfaktor Werkzeugverbrauch
   o5_tr                NUMERIC,
   o5_tr_fb_name        VARCHAR(20) REFERENCES ferber ON UPDATE CASCADE,
   o5_tr_fertdata       TEXT,
   o5_th                NUMERIC,
   o5_th_fb_name        VARCHAR(20) REFERENCES ferber ON UPDATE CASCADE,
   o5_th_fertdata       TEXT,
   o5_tn                NUMERIC,
   o5_tn_fb_name        VARCHAR(20) REFERENCES ferber ON UPDATE CASCADE,
   o5_tn_fertdata       TEXT,
   o5_fert_prozess      VARCHAR(50) -- Zugeordnete Fertigungsprozess für Techplan-Berechnungen
  );

  -- #7440 - Techplanparameter
  CREATE TRIGGER op5__a_iu__create_autoparams
    AFTER INSERT OR UPDATE
    ON op5
    FOR EACH ROW
  EXECUTE PROCEDURE TRecnoParam.CreateAutoParams();

 /*Rohmaterial*/

 CREATE TABLE op6mstat  --pro Los, pro Stück, pro Kg: Vorgabe für Berechnungsbezug Material
  (o6m_stat             INTEGER PRIMARY KEY,
   o6m_bz               VARCHAR(30) NOT NULL
  );
--

--
CREATE OR REPLACE FUNCTION get_mgcode_mm() RETURNS INTEGER AS $$
  BEGIN
    RETURN (SELECT me_cod FROM mgcode WHERE me_iso='mm');
  END $$ LANGUAGE plpgsql IMMUTABLE;
--

--
CREATE TABLE op6 (
  o6_id                SERIAL PRIMARY KEY,
  o6_aknr              VARCHAR(40) NOT NULL REFERENCES art ON UPDATE CASCADE,
  o6_ix                INTEGER NOT NULL REFERENCES opl (op_ix) ON UPDATE CASCADE ON DELETE CASCADE,
  o6_o2_id             INTEGER REFERENCES op2, -- direkte op2_id zB wegen umnummeriere-n, RESTRICT Anwender muss sich erst um Artikel kümmern analog op2ba
  o6_o2_n              INTEGER,

  --#5284
  o6_pos               INTEGER,      -- Pos. Nummer für Material
  o6_ap_nr             VARCHAR(40),  -- Materialbearbeitung, z.Bsp. Laserschneiden, Brennschneiden
  o6_zaknr             VARCHAR(40),  -- Feld Hilfsartikelnummer
  o6_CalcOnly          BOOL DEFAULT FALSE, -- Material nur kalkulatorisch nicht warenwirtschaftlich erfassen
  o6_txt               TEXT,         -- Arbeitsanweisung (ähnlich Arbeitsgangtext) für Erstellung Zuschnitt
  o6_txt_rtf           TEXT,
  o6_txtbem            TEXT,         -- Allgemeines Memofeld 'Bemerkung', mit allgemeinen Zusatzinformationen zum Material
  o6_txtbem_rtf        TEXT,
  o6_folgebearb1       TEXT,         -- für Folge - Arbeitsschritte (Bohren / Schleifen) nach dem Schneiden
  o6_folgebearb1_rtf   TEXT,
  o6_folgebearb2       TEXT,
  o6_folgebearb2_rtf   TEXT,
  o6_folgebearb3       TEXT,
  o6_folgebearb3_rtf   TEXT,
  --o6_gewicht           NUMERIC,
  o6_m                 NUMERIC(12,4) NOT NULL,
  o6_m_stat            INTEGER NOT NULL DEFAULT 0 REFERENCES op6mstat,-- 0=pro Stück, 1=pro Los
  o6_stat              VARCHAR(3),      --Status Beistellung, siehe ak_stat/st_stat
  o6_ekenner_krz       VARCHAR(20),
  o6_m_fb_name         VARCHAR(20) REFERENCES ferber ON UPDATE CASCADE,
  o6_m_fertdata        TEXT,
  o6_m_uf1             NUMERIC,
  o6_mce               INTEGER NOT NULL REFERENCES artmgc,
  o6_artpr             NUMERIC(12,4),
  o6_artpr_uf1         NUMERIC,
  o6_stkz              NUMERIC(12,4),  --Stück  Zuschnitt
  o6_lz                NUMERIC(12,4),  --Länge  Zuschnitt
  o6_bz                NUMERIC(12,4),  --Breite Zuschnitt
  o6_hz                NUMERIC(12,4),  --Höhe   Zuschnitt
  o6_zz                NUMERIC(12,4),  --Zugabe Zuschnitt
  o6_zme               INTEGER REFERENCES mgcode, -- DEFAULT get_mgcode_mm(), -- ZuschnittME
  o6_min               NUMERIC NOT NULL DEFAULT 0,
  o6_dimi              VARCHAR(30),
  o6_mgk               NUMERIC(12,4) NOT NULL DEFAULT 0
);

-- Indizes
  CREATE INDEX op6_ix ON op6(o6_ix, o6_aknr);
  CREATE INDEX op6_aknr ON op6(o6_aknr);
--

--
CREATE OR REPLACE FUNCTION op6__b_iu() RETURNS TRIGGER AS $$
  DECLARE me2 INTEGER;
          tnum INTEGER;
          tdim INTEGER;
          tcod INTEGER;
  BEGIN
    IF new.o6_aknr = (SELECT op_n FROM opl WHERE op_ix = new.o6_ix) THEN
        RAISE EXCEPTION '%', lang_text(29364);      -- 'Material darf sich nicht selbst enthalten'
    END IF;
    IF tg_op='INSERT' THEN
        --Prüfen ob Kode einmalig vorkommt
        IF new.o6_pos IS NULL THEN
            SELECT COALESCE((SELECT o6_pos+1 FROM op6 LEFT JOIN art ON ak_nr = new.o6_aknr
            WHERE o6_ix = new.o6_ix  AND o6_pos IS NOT NULL
            ORDER BY o6_pos DESC LIMIT 1), 1) INTO new.o6_pos;
        END IF;
    END IF;

    IF (new.o6_stkz IS NULL) AND (new.o6_lz>0) THEN
        RAISE EXCEPTION 'xtt26135'; --Zuschnittanzahl ist nicht vorhanden
    END IF;

    IF new.o6_CalcOnly AND new.o6_stkz IS NOT NULL THEN
        RAISE EXCEPTION '%', lang_text(16462);
    END IF;

    SELECT me_dim1, me_cod, me_dimnum FROM mgcode WHERE me_cod = TArtikel.me__mec__by__mid(new.o6_mce) INTO tdim, tcod, tnum;

    IF  ((tnum>2) AND (new.o6_hz IS NULL)) OR
        ((tnum>1) AND (new.o6_bz IS NULL)) OR
        ((tnum>0) AND (new.o6_lz <=0))
    THEN
        IF (new.o6_stkz IS NOT NULL) THEN
            RAISE EXCEPTION 'xtt26133'; --Nicht alle Parameter (Länge, Breite oder Höhe) sind vorhanden
        END IF;
    END IF;

    IF (new.o6_stkz IS NOT NULL) AND (new.o6_lz>0) AND (new.o6_zme IS NOT NULL) THEN --Zuschnittsangaben vorhanden
        IF tdim IS NULL THEN
            IF tnum=1 THEN me2:=tcod;
            ELSE
                --Zuschnitte AVOR: Umrechnung von '%' zum '%' ist nicht möglich
                RAISE EXCEPTION 'xtt26134, %;%', (SELECT me_iso FROM mgcode WHERE me_cod=new.o6_zme), (SELECT me_iso FROM mgcode WHERE me_cod=TArtikel.me__mec__by__mid(new.o6_mce));
            END IF;
        ELSE
            me2:=tdim;
        END IF;

        IF new.o6_zme IS NOT NULL THEN
        new.o6_m:=tartikel.zuschnittmenge(new.o6_lz,
                                          new.o6_bz,
                                          new.o6_hz,
                                          new.o6_zz,
                                          Round(new.o6_stkz)::INTEGER,
                                          TArtikel.me__art__artmgc__m_ids__uf(new.o6_zme, me2));
        ELSE --wenn Zuschnittmenge nicht eingegeben sind, dann wie früher rechnen
            new.o6_m:=tartikel.zuschnittmenge(new.o6_lz, new.o6_bz, new.o6_hz, new.o6_zz, Round(new.o6_stkz)::INTEGER);
    END IF;
    END IF;

    IF tg_op='UPDATE' THEN
        IF (new.o6_stkz IS NULL) AND (old.o6_stkz IS NOT NULL) THEN
            new.o6_stkz:=NULL;
            new.o6_lz:=NULL;
            new.o6_bz:=NULL;
            new.o6_hz:=NULL;
            new.o6_zz:=NULL;
        END IF;
    END IF;

    new.o6_m_uf1 := tartikel.me__menge__in__menge_uf1(new.o6_mce, new.o6_m);
    new.o6_artpr_uf1 := tartikel.me__preis__in__preis_uf1(new.o6_mce, new.o6_artpr);
    --
    IF current_user<>'syncro' THEN
        PERFORM TSystem.Settings__Set('disable_handle_opreg', 'T');
        UPDATE opl SET modified_date=current_date WHERE op_ix=new.o6_ix;--letztes Änderungsdatum ASK
        PERFORM TSystem.Settings__Set('disable_handle_opreg', 'F');
    END IF;
    --
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER op6__b_iu
    BEFORE UPDATE OR INSERT
    ON op6
    FOR EACH ROW
    EXECUTE PROCEDURE op6__b_iu();
--

--
CREATE OR REPLACE FUNCTION op6__a_iu() RETURNS TRIGGER AS $$
  BEGIN
    IF current_user<>'syncro' THEN
        PERFORM handle_opreg(new.o6_ix, NULL, 'op6', null);
    END IF;
    RETURN new;
  END $$ LANGUAGE plpgsql;

  CREATE TRIGGER op6__a_iu
    AFTER INSERT OR UPDATE
    ON op6
    FOR EACH ROW
    EXECUTE PROCEDURE op6__a_iu();
--


CREATE OR REPLACE FUNCTION op6__b_iu__o6_o2_n() RETURNS TRIGGER AS $$  --INSERT OR UPDATE OF o2ba_n
   BEGIN

     new.o6_o2_id := (SELECT o2_id
                        FROM op2
                       WHERE o2_ix = new.o6_ix
                         AND o2_n = new.o6_o2_n
                       );

     RETURN new;
   END $$ LANGUAGE plpgsql;


   CREATE TRIGGER op6__b_iu__o6_o2_n
    BEFORE INSERT OR UPDATE
    OF o6_o2_n
    ON op6
    FOR EACH ROW
    EXECUTE PROCEDURE op6__b_iu__o6_o2_n();

/*Kalkulation*/

-- Vorgabe der Kalkulationsstaffeln in Einstellungen (AVOR-Stammkarte, Kalkulation)
CREATE TABLE op7_template (
  o7t_ix               INTEGER,
  o7t_m                INTEGER NOT NULL CONSTRAINT larger_zero__o7t_m CHECK (o7t_m>0),
  o7t_korr             NUMERIC NOT NULL
);

-- Kalkulationsstaffeln
CREATE TABLE op7 (
  o7_id                SERIAL PRIMARY KEY,
  o7_op_ix             INTEGER NOT NULL REFERENCES opl ON UPDATE CASCADE ON DELETE CASCADE,
  o7_m                 INTEGER NOT NULL CONSTRAINT larger_zero__o7_m CHECK (o7_m>0),
  o7_korr              NUMERIC NOT NULL CONSTRAINT larger_zero__o7_korr CHECK (o7_korr>0),
  o7_txt               TEXT
  -- o7_mspr           NUMERIC/*Mengenstaffelpreis*/
);
---

-- globale Zuschläge
CREATE TABLE op7zko (
  o7zk_id              SERIAL PRIMARY KEY,
  o7zk_ix              INTEGER NOT NULL REFERENCES opl ON DELETE CASCADE,
  o7zk_krc_bez         VARCHAR(75),
  o7zk_proz            NUMERIC(12,6),
  o7zk_minhsk          NUMERIC(12,6), --MF: DROP?? Bedeutung? vermutlich nur aus kostrechgemko kopiert
  o7zk_lokogemz        BOOL NOT NULL DEFAULT FALSE --DROP??
);
---

-- CREATE UNIQUE INDEX op7_o7m_ix ON op7(o7_op_ix, o7_m);

 /*VIEW Preis Rohmaterial*/

 CREATE VIEW op6_kalk AS SELECT o6_ix, o6_aknr, o6_mce, o6_m, o6_artpr ,SUM(o6_m*o6_artpr) AS sumpr FROM op6 GROUP BY o6_ix, o6_aknr, o6_mce, o6_m, o6_artpr;

 /*Prüfplan für Teilestatus*/

 CREATE TABLE op8
  (
   o8_id                SERIAL PRIMARY KEY,
   o8_ix                INTEGER REFERENCES opl (op_ix) ON UPDATE CASCADE ON DELETE CASCADE, --Zugeordnete ASK
   o8_op_stat           VARCHAR(3) NOT NULL CONSTRAINT xtt5001 REFERENCES oplstat, -- Zugeordnete Bezeichnungen
   o8_pos               SMALLINT NOT NULL,                              --Index im Prüfplan
   o8_active            BOOL NOT NULL DEFAULT TRUE,                     --Prüfstatus ist aktiv ==> bei Planung berücksichtigen
   o8_validmonth        INTEGER,                                        --Anzahl Monate bis Gültigkeit erlischt
   o8_expdate           DATE,                                           --(expiration date)Datum an dem Gültigkeit erlischt
   o8_validunits        INTEGER,                                        --Anzahl herstellbarer Teile bevor Gültigkeit erlischt
   o8_unitsleft INTEGER,                                        --Noch verbleibende herstellbare Teile
   o8_validcycles       INTEGER,                                        --Anzahl Arbeitsgänge bis Gültigkeit erlischt
   o8_cyclesleft        INTEGER,                                        --Noch verbleibende Arbeitsgänge
   o8_validmonthdlv     INTEGER,                                        --"Valid Month since delivery", Gültigkeit erlischt, wenn mehr als x Monate seit der letzten Lieferung vergangen sind
   o8_expdatedlv        DATE                                            --(expiration date delivery) Datum an dem die beschränkung aus validmonthdlv greift
  );

  CREATE UNIQUE INDEX PosNrEinmal ON op8 (o8_ix,o8_pos);
  CREATE UNIQUE INDEX TStatNrEinmal ON op8 (o8_ix,o8_op_stat);

  /*Prüft bei Spaltenupdate, ob Prüfbedingungen (o8_cyclesleft,o8_unitsleft, o8_expDate)
  verletzt werden. Exception verhindert update des Datensatzes.*/

  CREATE OR REPLACE FUNCTION op8__a_u() RETURNS TRIGGER AS $$
   DECLARE invalidopstat VARCHAR;
   BEGIN
    --
    SELECT os_stat || ' ' || COALESCE(os_bez) INTO invalidopstat FROM oplstat WHERE os_stat=new.o8_op_stat;
    invalidopstat:='xtt6304'||E'\n'|| '"'||invalidopstat||'"';
    --
    IF new.o8_active AND
      (
      (COALESCE(new.o8_cyclesleft,0) < 0) OR
      (COALESCE(new.o8_unitsleft,0) < 0) OR
      (COALESCE(new.o8_expDate, current_date) < current_date)
      )
     THEN
       RAISE EXCEPTION '%', invalidopstat;
    END IF;

    IF new.o8_active THEN--für letzte Lieferung
      IF new.o8_expDatedlv IS NULL THEN--Datum letzte Lieferung wurde gelöscht, sperre aufgehoben
         RETURN new;
      END IF;
      --
      If (COALESCE(old.o8_expDatedlv, current_date) < current_date) THEN--Datum ist abgelaufen (gewesen), zur Freigabe müßte das erst gelöscht werden
         RAISE EXCEPTION '%', invalidopstat;
      END IF;
    END IF;

    RETURN new;
   END $$ LANGUAGE plpgsql;

   CREATE TRIGGER op8__a_u
    AFTER UPDATE
    ON op8
    FOR EACH ROW
    EXECUTE PROCEDURE op8__a_u();
  ---

/*Qualitätssicherung*/

 /* Vorgaben: Normen und Zertifikate beachte normzert*/
 CREATE TABLE qsnorm
  (qs_ident             VARCHAR(50) PRIMARY KEY,                                                -- Kurzname der Norm
   qs_pnzt_type         VARCHAR(20) NOT NULL REFERENCES pre_NormZertTyp ON UPDATE CASCADE,      -- Typ[Auswahl Norm/Zertifikat]
   qs_norm              VARCHAR(75),                                                            -- Name, Bezeichnung der Norm
   qs_txt               TEXT,                                                                   -- Hinweistext
   qs_edikz             VARCHAR(1)
  );

 ALTER TABLE art ADD CONSTRAINT art_qsnorm FOREIGN KEY (ak_norm) REFERENCES qsnorm(qs_ident) ON UPDATE CASCADE;
 ALTER TABLE adk1 ADD CONSTRAINT adk1_qsnorm FOREIGN KEY (a1_norm) REFERENCES qsnorm(qs_ident) ON UPDATE CASCADE;
 ALTER TABLE adk2 ADD CONSTRAINT adk2_qsnorm FOREIGN KEY (a2_norm) REFERENCES qsnorm(qs_ident) ON UPDATE CASCADE;


 CREATE TABLE qsdok
  (qd_doknr             VARCHAR(40) NOT NULL PRIMARY KEY,
   qd_bez               VARCHAR(75),
   qd_bes               TEXT
  );

 CREATE TABLE qslnd
  (qsl_id               SERIAL NOT NULL PRIMARY KEY,
   qsl_ident            VARCHAR(50) NOT NULL REFERENCES qsnorm ON UPDATE CASCADE,
   qsl_doknr            VARCHAR(40) NOT NULL REFERENCES qsdok ON UPDATE CASCADE,
   qsl_bes              TEXT
  );

 CREATE TABLE artpr
  (pr_id                SERIAL PRIMARY KEY,
   pr_aknr              VARCHAR(40) NOT NULL REFERENCES art ON UPDATE CASCADE, -- Artikelnummer als Referenz
   pr_pmnr              VARCHAR(50), -- Prüfmittel-/Inventar- Nummer
   pr_hest              VARCHAR(50), -- Hersteller
   pr_mebe              VARCHAR(50), -- Messbereich
   pr_an12              INTEGER DEFAULT 1, -- Anzahl Messungen, von
   pr_an34              INTEGER DEFAULT 0, -- Anzahl Messungen, bis
   pr_tol1              VARCHAR(20), -- Toleranz 1, von
   pr_tol3              VARCHAR(20), -- Toleranz 1, bis
   pr_tol4              VARCHAR(20), -- Toleranz 2, bis
   pr_tol2              VARCHAR(20), -- Toleranz 2, von
   pr_mege              VARCHAR(20), -- Messgenauigkeit
   pr_part              VARCHAR(20), -- Prüfart
   pr_pzyk              VARCHAR(20), -- Prüfintervall
   pr_ibda              DATE,        -- Datum der Inbetriebnahme
   pr_lpda              DATE,        -- letztes Prüfdatum
   pr_lqda              DATE,        -- Datum Aussonderung
   pr_ifreig            BOOL,        -- interne Freigabe trotz Aussonderungsdatum
   pr_ifreigtxt         TEXT,        -- interne Freigabe Erläuterung (Freigabebereich)
   pr_npda              DATE,        -- nächstes Prüfdatum
   pr_befu              VARCHAR(50), -- Befund
   pr_prue              VARCHAR(50), -- Name des Prüfers
   pr_hkrz              VARCHAR(21) REFERENCES adk ON UPDATE CASCADE, -- Kurzname des Prüfers
   pr_auda              DATE,        -- Datum der Prüfmittel-Ausgabe
   pr_ort               VARCHAR(50), -- Ort der Prüfmittel-Ausgabe
   pr_rldat             DATE,        -- Datum der Rücklieferung
   pr_minr              integer,     -- Mitarbeiter, an den das Prüfmittel ausgehändigt wurde
   pr_abix              integer,     -- die dem Prüfmittel zugeordnete ABK
   pr_slort             varchar(50), -- Inventarlagerort der Prüfmittelinstanz, nicht zu verwechseln mit dem Standardlagerort des Artikels
   pr_kat               varchar(3),  -- Messmittelgruppe
   pr_snhest            varchar(50)  -- Seriennummer Hersteller
  );

  CREATE UNIQUE INDEX pr_aknr_pmnr ON artpr (pr_aknr,pr_pmnr);


  CREATE TRIGGER artpr_delete_abk_project_structure AFTER DELETE ON artpr FOR EACH ROW EXECUTE PROCEDURE table_delete_abkstru();


CREATE TABLE opreg
 (or_id                 SERIAL PRIMARY KEY,
  or_ix                 INTEGER,
  or_ag                 INTEGER,--arbeitsgang
  or_da                 DATE DEFAULT CAST(currenttime() AS DATE),
  or_ze                 TIME(0) WITHOUT TIME ZONE DEFAULT CAST(currenttime() AS TIME),
  or_mi                 VARCHAR(30) DEFAULT tsystem.current_user_ll_db_usename(true),
  or_ka                 VARCHAR(9),--kostenstelle --references ksv
  or_kn                 VARCHAR(9),--kostenstelle neu --references ksv
  or_mt                 VARCHAR(1),--material geändert
  or_fz                 VARCHAR(1),--fertigungszeit geändert
  or_tx                 VARCHAR(1),--text geändert
  or_ko                 VARCHAR(1),--
  or_sa                 NUMERIC,--kosten alt
  or_sn                 NUMERIC,--kosten neu
  --or_vi               VARCHAR(1),--Variante
  --or_zn               VARCHAR(40),--artikel
  or_st                 VARCHAR(1)--
  -- System (tables__generate_missing_fields)
  --   kein automatisches dbrid, insert_date, insert_by, modified_by, modified_date und table_delete-Trigger (tables__fieldInfo__fetch)
  );


 CREATE INDEX opreg_or_ix ON opreg (or_ix);


 CREATE OR REPLACE FUNCTION handle_opreg(INTEGER, INTEGER, VARCHAR, VARCHAR) RETURNS VOID AS $$
  DECLARE _opix ALIAS FOR $1;
         _ag ALIAS FOR $2;
         _table ALIAS FOR $3;
         textchange ALIAS FOR $4;
         ksalt VARCHAR;
         olddat RECORD;
         newdat RECORD;
         kostnew NUMERIC;
  BEGIN
      --
      IF current_user='syncro' THEN
        RETURN;
      END IF;
      --
      SELECT * INTO newdat FROM op2 WHERE o2_ix=_opix AND o2_n=_ag;
      SELECT * INTO olddat FROM opreg WHERE or_ix=_opix ORDER BY or_id DESC LIMIT 1;
      ksalt:=olddat.or_kn;
      IF _ag IS NOT NULL THEN--wir müssen die alte KS zu diesem AG raussuchen
        SELECT or_kn INTO ksalt FROM opreg WHERE or_ix=_opix AND or_ag=_ag ORDER BY or_id DESC LIMIT 1;
      END IF;
      kostnew:=tartikel.op2_rkost(_opix)+tartikel.op2_mkost(_opix)+tartikel.op2_akost(_opix)+tartikel.op6_kost(_opix);
      INSERT INTO opreg (or_ix, or_ka, or_kn, or_mt, or_fz, or_sa, or_sn, or_ag, or_tx)
                  VALUES (_opix, IfThen(_table='op2', ksalt, NULL), newdat.o2_ks, IfThen(_table='op6', 'X', NULL), IfThen(_table='op2', 'X', NULL) , olddat.or_sn, kostnew, _ag, textchange);
      RETURN;
  END $$ LANGUAGE plpgsql;

-- Tabelle zur Verwaltung der generierten NCP-Nummern auf Basis der KS
CREATE TABLE ncprogram (
    -- ID
    ncp_id               serial PRIMARY KEY,
    -- Kostenstellenkürzel VF. mehrere KS können gleiches Kürzel haben. Kinematisch baugleich , Präfix für ncp_ncnr
    ncp_prefix           varchar(2),
    -- fortlaufende Nr pro ks_kinematic_group, Suffix für ncp_ncnr
    ncp_suffix           integer,
    -- NC-Programm-Nr.: ks_kinematic_group + lpad + ncp_value (6 stellig)
    ncp_ncnr             varchar(20) NOT NULL UNIQUE,
    -- produzierte Teile pro Programmlauf
    ncp_teile_pro_lauf   integer NOT NULL DEFAULT 1,

    CONSTRAINT xtt32603 CHECK ( ncp_teile_pro_lauf > 0 )
);

COMMENT ON TABLE ncprogram IS 'Tabelle zur Ablage der generierten NC-Nummern auf Basis der KS' ;


CREATE TABLE ncp_o2_a2_ksv (
    -- ID
    ncpoak_id     serial PRIMARY KEY,
    -- ID des NCProgramms
    ncpoak_ncp_id integer NOT NULL REFERENCES ncprogram( ncp_id ) ON UPDATE CASCADE ON DELETE CASCADE,
    -- ID des ASK-Arbeitsgangs
    ncpoak_o2_id  integer REFERENCES op2( o2_id ) ON UPDATE CASCADE ON DELETE CASCADE,

    -- ID des ABK-Arbeitsgangs
    -- Referenz auf ab2 erfolgt in TableConstraints (ab2 noch nicht vorhanden)
    -- REFERENCES ab2(a2_id) ON UPDATE CASCADE ON DELETE CASCADE,
    ncpoak_a2_id  integer,
    -- Kostenstelle
    ncpoak_ks     varchar(9) NOT NULL REFERENCES ksv ( ks_abt ) ON UPDATE CASCADE ON DELETE CASCADE,
    ncpoak_txt    TEXT,

    -- entweder AG oder ASK dürfen nur gefüllt sein
    CONSTRAINT xtt32602 CHECK ( ncpoak_o2_id IS NULL OR ncpoak_a2_id IS NULL )
);

COMMENT ON TABLE ncp_o2_a2_ksv IS 'Tabelle zur Zuordnung des NCProgramms zum AG bzw. der ABK und der KS' ;

--Demontage oder Umbau oder Upgrade
CREATE OR REPLACE FUNCTION TQS.ldsdok__demontage__is(_ldid integer) RETURNS boolean AS $$
DECLARE
  _stat text;
BEGIN
  _stat := (SELECT ld_stat FROM ldsdok WHERE ld_id = _ldid);
  IF _stat IS NULL THEN
    RETURN false;
  ELSE
    RETURN (   TSystem.ENUM_GetValue(_stat, 'DM')
            OR TSystem.ENUM_GetValue(_stat, 'UB')
            OR TSystem.ENUM_GetValue(_stat, 'UG')
           );
  END IF;
END $$ language plpgsql STABLE;


-- Demontage oder Umbau oder Upgrade
-- > FUNCTION TQS.abk__demontage__is(_abk abk); FUNCTION TQS.abk__demontage__is(_abix integer)


-- #17982 Kopfposition der automatisch schliessen
CREATE OR REPLACE FUNCTION TQS.ldsdok__demontage_head_done__set(_ldid integer) RETURNS VOID AS $$
DECLARE
  _abk_done boolean;
  _alle_pos_done boolean;
  _ldauftg varchar;
BEGIN
  SELECT ld_auftg FROM ldsdok WHERE ld_id = _ldid INTO _ldauftg;
  --verlinkte ABK der Kopfsposition ist erledigt
  _abk_done = EXISTS(SELECT
                       true
                     FROM
                       ldsdok
                     WHERE
                       ld_id = teinkauf.ldsdok_get_ldsdokmainpos(_ldid) --Kopfsposition
                       AND TQS.ldsdok__demontage__is(ld_id)
                       AND ld_abk IS NOT NULL            --hat ABK
                       AND EXISTS(SELECT true FROM abk WHERE ab_ix = ld_abk AND ab_done) --und ABK ist erledigt
                    );

  --alle anderen Bestellpositionen derselben Bestellung sind geschlossen
  _alle_pos_done = NOT EXISTS(SELECT
                                true
                              FROM
                                ldsdok
                              WHERE
                                ld_auftg = _ldauftg
                                AND ld_hpos IS NOT NULL           --Kopfsposition ausschliessen
                                AND ld_id <> _ldid                --alle Bestellpositionen außer aktueller
                                AND TQS.ldsdok__demontage__is(ld_id)
                                AND NOT(ld_done)                  --nicht geschlossen
                             );

  IF (_abk_done AND _alle_pos_done) THEN
    --Kopfposition der Bestellung automatisch schliessen
    UPDATE
      ldsdok
    SET
      ld_done = TRUE
    WHERE
      ld_auftg = _ldauftg
      AND TQS.ldsdok__demontage__is(ld_id)
      AND ld_hpos IS NULL                --Kopfsposition
      AND ld_done IS DISTINCT FROM TRUE; --nur schließen falls noch nicht geschlossen
  END IF;
END $$ LANGUAGE plpgsql;


-- #18181 Tabelle zur Verknüprung von Messdatensätzen mit ABKs für Messungen mit Seriennummern
CREATE TABLE IF NOT EXISTS mapsernr_mw (
    msmw_id serial PRIMARY KEY,                 -- technischer Primärschlüssel
    msmw_abix integer NOT null,                 -- ABK-Verweis
    msmw_lfdnr integer NOT null                 -- laufende Nummer des Messdatensatzes
);

CREATE UNIQUE INDEX mapsernr_mw__msmw_abix__msmw_lfdnr__uq ON mapsernr_mw( msmw_abix, msmw_lfdnr );


-- keine leeren Statements am Ende vom Erstellen der DB erlaubt.
SELECT TRUE;
